/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include <boost/version.hpp>
#include "CylinderVolPy.h"

using namespace boost::python;

    void exportCylinderVol()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      class_<CylinderVol, bases<AVolume3D> >(
        "CylinderVol",
        "A class defining a cylindrical L{AVolume3D}.",
        init<>()
      )
      .def(init<const CylinderVol &>())
      .def(
        init<Vector3,Vector3,double,double>(
          ( arg("origin"), arg("axis"), arg("length"), arg("radius") ),
          "Constructs a cylinder with the specified origin, axis, length and radius.\n"
          "@type origin: L{Vector3}\n"
          "@kwarg origin: Coordinate of origin (centre of base) of the cylinder\n"
          "@type axis: L{Vector3}\n"
          "@kwarg axis: Unit vector in the direction of the cylinder axis\n"
          "@type length: double\n"
          "@kwarg length: Length of the cylinder\n"
          "@type radius: double\n"
          "@kwarg radius: Radius of the cylinder\n"
        )
      )
      .def(self_ns::str(self))
      ;
    }



