# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import Any, Callable, Dict, Generic, Optional, TypeVar, Union
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._subscription_operations import build_accept_ownership_request_initial, build_accept_ownership_status_request, build_cancel_request, build_enable_request, build_rename_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class SubscriptionOperations:
    """SubscriptionOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.subscription.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def cancel(
        self,
        subscription_id: str,
        **kwargs: Any
    ) -> "_models.CanceledSubscriptionId":
        """The operation to cancel a subscription.

        :param subscription_id: Subscription Id.
        :type subscription_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CanceledSubscriptionId, or the result of cls(response)
        :rtype: ~azure.mgmt.subscription.models.CanceledSubscriptionId
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CanceledSubscriptionId"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_cancel_request(
            subscription_id=subscription_id,
            template_url=self.cancel.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseBody, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('CanceledSubscriptionId', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    cancel.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/cancel'}  # type: ignore


    @distributed_trace_async
    async def rename(
        self,
        subscription_id: str,
        body: "_models.SubscriptionName",
        **kwargs: Any
    ) -> "_models.RenamedSubscriptionId":
        """The operation to rename a subscription.

        :param subscription_id: Subscription Id.
        :type subscription_id: str
        :param body: Subscription Name.
        :type body: ~azure.mgmt.subscription.models.SubscriptionName
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RenamedSubscriptionId, or the result of cls(response)
        :rtype: ~azure.mgmt.subscription.models.RenamedSubscriptionId
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.RenamedSubscriptionId"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'SubscriptionName')

        request = build_rename_request(
            subscription_id=subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self.rename.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseBody, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('RenamedSubscriptionId', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    rename.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/rename'}  # type: ignore


    @distributed_trace_async
    async def enable(
        self,
        subscription_id: str,
        **kwargs: Any
    ) -> "_models.EnabledSubscriptionId":
        """The operation to enable a subscription.

        :param subscription_id: Subscription Id.
        :type subscription_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EnabledSubscriptionId, or the result of cls(response)
        :rtype: ~azure.mgmt.subscription.models.EnabledSubscriptionId
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.EnabledSubscriptionId"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_enable_request(
            subscription_id=subscription_id,
            template_url=self.enable.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseBody, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('EnabledSubscriptionId', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    enable.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.Subscription/enable'}  # type: ignore


    async def _accept_ownership_initial(
        self,
        subscription_id: str,
        body: "_models.AcceptOwnershipRequest",
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'AcceptOwnershipRequest')

        request = build_accept_ownership_request_initial(
            subscription_id=subscription_id,
            content_type=content_type,
            json=_json,
            template_url=self._accept_ownership_initial.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers['Location']=self._deserialize('str', response.headers.get('Location'))
        response_headers['Retry-After']=self._deserialize('int', response.headers.get('Retry-After'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    _accept_ownership_initial.metadata = {'url': '/providers/Microsoft.Subscription/subscriptions/{subscriptionId}/acceptOwnership'}  # type: ignore


    @distributed_trace_async
    async def begin_accept_ownership(
        self,
        subscription_id: str,
        body: "_models.AcceptOwnershipRequest",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Accept subscription ownership.

        :param subscription_id: Subscription Id.
        :type subscription_id: str
        :param body:
        :type body: ~azure.mgmt.subscription.models.AcceptOwnershipRequest
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, azure.core.polling.AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._accept_ownership_initial(
                subscription_id=subscription_id,
                body=body,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})


        if polling is True: polling_method = AsyncARMPolling(lro_delay, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_accept_ownership.metadata = {'url': '/providers/Microsoft.Subscription/subscriptions/{subscriptionId}/acceptOwnership'}  # type: ignore

    @distributed_trace_async
    async def accept_ownership_status(
        self,
        subscription_id: str,
        **kwargs: Any
    ) -> "_models.AcceptOwnershipStatusResponse":
        """Accept subscription ownership status.

        :param subscription_id: Subscription Id.
        :type subscription_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AcceptOwnershipStatusResponse, or the result of cls(response)
        :rtype: ~azure.mgmt.subscription.models.AcceptOwnershipStatusResponse
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AcceptOwnershipStatusResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_accept_ownership_status_request(
            subscription_id=subscription_id,
            template_url=self.accept_ownership_status.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponseBody, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('AcceptOwnershipStatusResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    accept_ownership_status.metadata = {'url': '/providers/Microsoft.Subscription/subscriptions/{subscriptionId}/acceptOwnershipStatus'}  # type: ignore

