# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessPolicy(msrest.serialization.Model):
    """An Access policy.

    :ivar start: the date-time the policy is active.
    :vartype start: str
    :ivar expiry: the date-time the policy expires.
    :vartype expiry: str
    :ivar permission: the permissions for the acl policy.
    :vartype permission: str
    """

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str'},
        'expiry': {'key': 'Expiry', 'type': 'str'},
        'permission': {'key': 'Permission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: the date-time the policy is active.
        :paramtype start: str
        :keyword expiry: the date-time the policy expires.
        :paramtype expiry: str
        :keyword permission: the permissions for the acl policy.
        :paramtype permission: str
        """
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)
        self.permission = kwargs.get('permission', None)


class AppendPositionAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar max_size: Optional conditional header. The max length in bytes permitted for the append
     blob. If the Append Block operation would cause the blob to exceed that limit or if the blob
     size is already greater than the value specified in this header, the request will fail with
     MaxBlobSizeConditionNotMet error (HTTP status code 412 - Precondition Failed).
    :vartype max_size: long
    :ivar append_position: Optional conditional header, used only for the Append Block operation. A
     number indicating the byte offset to compare. Append Block will succeed only if the append
     position is equal to this number. If it is not, the request will fail with the
     AppendPositionConditionNotMet error (HTTP status code 412 - Precondition Failed).
    :vartype append_position: long
    """

    _attribute_map = {
        'max_size': {'key': 'maxSize', 'type': 'long'},
        'append_position': {'key': 'appendPosition', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_size: Optional conditional header. The max length in bytes permitted for the
         append blob. If the Append Block operation would cause the blob to exceed that limit or if the
         blob size is already greater than the value specified in this header, the request will fail
         with MaxBlobSizeConditionNotMet error (HTTP status code 412 - Precondition Failed).
        :paramtype max_size: long
        :keyword append_position: Optional conditional header, used only for the Append Block
         operation. A number indicating the byte offset to compare. Append Block will succeed only if
         the append position is equal to this number. If it is not, the request will fail with the
         AppendPositionConditionNotMet error (HTTP status code 412 - Precondition Failed).
        :paramtype append_position: long
        """
        super(AppendPositionAccessConditions, self).__init__(**kwargs)
        self.max_size = kwargs.get('max_size', None)
        self.append_position = kwargs.get('append_position', None)


class ArrowConfiguration(msrest.serialization.Model):
    """Groups the settings used for formatting the response if the response should be Arrow formatted.

    All required parameters must be populated in order to send to Azure.

    :ivar schema: Required.
    :vartype schema: list[~azure.storage.blob.models.ArrowField]
    """

    _validation = {
        'schema': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': 'Schema', 'type': '[ArrowField]', 'xml': {'name': 'Schema', 'wrapped': True, 'itemsName': 'Field'}},
    }
    _xml_map = {
        'name': 'ArrowConfiguration'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword schema: Required.
        :paramtype schema: list[~azure.storage.blob.models.ArrowField]
        """
        super(ArrowConfiguration, self).__init__(**kwargs)
        self.schema = kwargs['schema']


class ArrowField(msrest.serialization.Model):
    """Groups settings regarding specific field of an arrow schema.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required.
    :vartype type: str
    :ivar name:
    :vartype name: str
    :ivar precision:
    :vartype precision: int
    :ivar scale:
    :vartype scale: int
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'precision': {'key': 'Precision', 'type': 'int'},
        'scale': {'key': 'Scale', 'type': 'int'},
    }
    _xml_map = {
        'name': 'Field'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required.
        :paramtype type: str
        :keyword name:
        :paramtype name: str
        :keyword precision:
        :paramtype precision: int
        :keyword scale:
        :paramtype scale: int
        """
        super(ArrowField, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.name = kwargs.get('name', None)
        self.precision = kwargs.get('precision', None)
        self.scale = kwargs.get('scale', None)


class BlobFlatListSegment(msrest.serialization.Model):
    """BlobFlatListSegment.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_items: Required.
    :vartype blob_items: list[~azure.storage.blob.models.BlobItemInternal]
    """

    _validation = {
        'blob_items': {'required': True},
    }

    _attribute_map = {
        'blob_items': {'key': 'BlobItems', 'type': '[BlobItemInternal]'},
    }
    _xml_map = {
        'name': 'Blobs'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_items: Required.
        :paramtype blob_items: list[~azure.storage.blob.models.BlobItemInternal]
        """
        super(BlobFlatListSegment, self).__init__(**kwargs)
        self.blob_items = kwargs['blob_items']


class BlobHierarchyListSegment(msrest.serialization.Model):
    """BlobHierarchyListSegment.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_prefixes:
    :vartype blob_prefixes: list[~azure.storage.blob.models.BlobPrefix]
    :ivar blob_items: Required.
    :vartype blob_items: list[~azure.storage.blob.models.BlobItemInternal]
    """

    _validation = {
        'blob_items': {'required': True},
    }

    _attribute_map = {
        'blob_prefixes': {'key': 'BlobPrefixes', 'type': '[BlobPrefix]', 'xml': {'name': 'BlobPrefix'}},
        'blob_items': {'key': 'BlobItems', 'type': '[BlobItemInternal]', 'xml': {'name': 'Blob', 'itemsName': 'Blob'}},
    }
    _xml_map = {
        'name': 'Blobs'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_prefixes:
        :paramtype blob_prefixes: list[~azure.storage.blob.models.BlobPrefix]
        :keyword blob_items: Required.
        :paramtype blob_items: list[~azure.storage.blob.models.BlobItemInternal]
        """
        super(BlobHierarchyListSegment, self).__init__(**kwargs)
        self.blob_prefixes = kwargs.get('blob_prefixes', None)
        self.blob_items = kwargs['blob_items']


class BlobHTTPHeaders(msrest.serialization.Model):
    """Parameter group.

    :ivar blob_cache_control: Optional. Sets the blob's cache control. If specified, this property
     is stored with the blob and returned with a read request.
    :vartype blob_cache_control: str
    :ivar blob_content_type: Optional. Sets the blob's content type. If specified, this property is
     stored with the blob and returned with a read request.
    :vartype blob_content_type: str
    :ivar blob_content_md5: Optional. An MD5 hash of the blob content. Note that this hash is not
     validated, as the hashes for the individual blocks were validated when each was uploaded.
    :vartype blob_content_md5: bytearray
    :ivar blob_content_encoding: Optional. Sets the blob's content encoding. If specified, this
     property is stored with the blob and returned with a read request.
    :vartype blob_content_encoding: str
    :ivar blob_content_language: Optional. Set the blob's content language. If specified, this
     property is stored with the blob and returned with a read request.
    :vartype blob_content_language: str
    :ivar blob_content_disposition: Optional. Sets the blob's Content-Disposition header.
    :vartype blob_content_disposition: str
    """

    _attribute_map = {
        'blob_cache_control': {'key': 'blobCacheControl', 'type': 'str'},
        'blob_content_type': {'key': 'blobContentType', 'type': 'str'},
        'blob_content_md5': {'key': 'blobContentMD5', 'type': 'bytearray'},
        'blob_content_encoding': {'key': 'blobContentEncoding', 'type': 'str'},
        'blob_content_language': {'key': 'blobContentLanguage', 'type': 'str'},
        'blob_content_disposition': {'key': 'blobContentDisposition', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_cache_control: Optional. Sets the blob's cache control. If specified, this
         property is stored with the blob and returned with a read request.
        :paramtype blob_cache_control: str
        :keyword blob_content_type: Optional. Sets the blob's content type. If specified, this property
         is stored with the blob and returned with a read request.
        :paramtype blob_content_type: str
        :keyword blob_content_md5: Optional. An MD5 hash of the blob content. Note that this hash is
         not validated, as the hashes for the individual blocks were validated when each was uploaded.
        :paramtype blob_content_md5: bytearray
        :keyword blob_content_encoding: Optional. Sets the blob's content encoding. If specified, this
         property is stored with the blob and returned with a read request.
        :paramtype blob_content_encoding: str
        :keyword blob_content_language: Optional. Set the blob's content language. If specified, this
         property is stored with the blob and returned with a read request.
        :paramtype blob_content_language: str
        :keyword blob_content_disposition: Optional. Sets the blob's Content-Disposition header.
        :paramtype blob_content_disposition: str
        """
        super(BlobHTTPHeaders, self).__init__(**kwargs)
        self.blob_cache_control = kwargs.get('blob_cache_control', None)
        self.blob_content_type = kwargs.get('blob_content_type', None)
        self.blob_content_md5 = kwargs.get('blob_content_md5', None)
        self.blob_content_encoding = kwargs.get('blob_content_encoding', None)
        self.blob_content_language = kwargs.get('blob_content_language', None)
        self.blob_content_disposition = kwargs.get('blob_content_disposition', None)


class BlobItemInternal(msrest.serialization.Model):
    """An Azure Storage blob.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: ~azure.storage.blob.models.BlobName
    :ivar deleted: Required.
    :vartype deleted: bool
    :ivar snapshot: Required.
    :vartype snapshot: str
    :ivar version_id:
    :vartype version_id: str
    :ivar is_current_version:
    :vartype is_current_version: bool
    :ivar properties: Required. Properties of a blob.
    :vartype properties: ~azure.storage.blob.models.BlobPropertiesInternal
    :ivar metadata:
    :vartype metadata: ~azure.storage.blob.models.BlobMetadata
    :ivar blob_tags: Blob tags.
    :vartype blob_tags: ~azure.storage.blob.models.BlobTags
    :ivar has_versions_only:
    :vartype has_versions_only: bool
    :ivar object_replication_metadata: Dictionary of :code:`<string>`.
    :vartype object_replication_metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'deleted': {'required': True},
        'snapshot': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'BlobName'},
        'deleted': {'key': 'Deleted', 'type': 'bool'},
        'snapshot': {'key': 'Snapshot', 'type': 'str'},
        'version_id': {'key': 'VersionId', 'type': 'str'},
        'is_current_version': {'key': 'IsCurrentVersion', 'type': 'bool'},
        'properties': {'key': 'Properties', 'type': 'BlobPropertiesInternal'},
        'metadata': {'key': 'Metadata', 'type': 'BlobMetadata'},
        'blob_tags': {'key': 'BlobTags', 'type': 'BlobTags'},
        'has_versions_only': {'key': 'HasVersionsOnly', 'type': 'bool'},
        'object_replication_metadata': {'key': 'OrMetadata', 'type': '{str}'},
    }
    _xml_map = {
        'name': 'Blob'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: ~azure.storage.blob.models.BlobName
        :keyword deleted: Required.
        :paramtype deleted: bool
        :keyword snapshot: Required.
        :paramtype snapshot: str
        :keyword version_id:
        :paramtype version_id: str
        :keyword is_current_version:
        :paramtype is_current_version: bool
        :keyword properties: Required. Properties of a blob.
        :paramtype properties: ~azure.storage.blob.models.BlobPropertiesInternal
        :keyword metadata:
        :paramtype metadata: ~azure.storage.blob.models.BlobMetadata
        :keyword blob_tags: Blob tags.
        :paramtype blob_tags: ~azure.storage.blob.models.BlobTags
        :keyword has_versions_only:
        :paramtype has_versions_only: bool
        :keyword object_replication_metadata: Dictionary of :code:`<string>`.
        :paramtype object_replication_metadata: dict[str, str]
        """
        super(BlobItemInternal, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.deleted = kwargs['deleted']
        self.snapshot = kwargs['snapshot']
        self.version_id = kwargs.get('version_id', None)
        self.is_current_version = kwargs.get('is_current_version', None)
        self.properties = kwargs['properties']
        self.metadata = kwargs.get('metadata', None)
        self.blob_tags = kwargs.get('blob_tags', None)
        self.has_versions_only = kwargs.get('has_versions_only', None)
        self.object_replication_metadata = kwargs.get('object_replication_metadata', None)


class BlobMetadata(msrest.serialization.Model):
    """BlobMetadata.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, str]
    :ivar encrypted:
    :vartype encrypted: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{str}'},
        'encrypted': {'key': 'Encrypted', 'type': 'str', 'xml': {'attr': True}},
    }
    _xml_map = {
        'name': 'Metadata'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, str]
        :keyword encrypted:
        :paramtype encrypted: str
        """
        super(BlobMetadata, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.encrypted = kwargs.get('encrypted', None)


class BlobName(msrest.serialization.Model):
    """BlobName.

    :ivar encoded: Indicates if the blob name is encoded.
    :vartype encoded: bool
    :ivar content: The name of the blob.
    :vartype content: str
    """

    _attribute_map = {
        'encoded': {'key': 'Encoded', 'type': 'bool', 'xml': {'name': 'Encoded', 'attr': True}},
        'content': {'key': 'content', 'type': 'str', 'xml': {'text': True}},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword encoded: Indicates if the blob name is encoded.
        :paramtype encoded: bool
        :keyword content: The name of the blob.
        :paramtype content: str
        """
        super(BlobName, self).__init__(**kwargs)
        self.encoded = kwargs.get('encoded', None)
        self.content = kwargs.get('content', None)


class BlobPrefix(msrest.serialization.Model):
    """BlobPrefix.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: ~azure.storage.blob.models.BlobName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'BlobName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: ~azure.storage.blob.models.BlobName
        """
        super(BlobPrefix, self).__init__(**kwargs)
        self.name = kwargs['name']


class BlobPropertiesInternal(msrest.serialization.Model):
    """Properties of a blob.

    All required parameters must be populated in order to send to Azure.

    :ivar creation_time:
    :vartype creation_time: ~datetime.datetime
    :ivar last_modified: Required.
    :vartype last_modified: ~datetime.datetime
    :ivar etag: Required.
    :vartype etag: str
    :ivar content_length: Size in bytes.
    :vartype content_length: long
    :ivar content_type:
    :vartype content_type: str
    :ivar content_encoding:
    :vartype content_encoding: str
    :ivar content_language:
    :vartype content_language: str
    :ivar content_md5:
    :vartype content_md5: bytearray
    :ivar content_disposition:
    :vartype content_disposition: str
    :ivar cache_control:
    :vartype cache_control: str
    :ivar blob_sequence_number:
    :vartype blob_sequence_number: long
    :ivar blob_type: Possible values include: "BlockBlob", "PageBlob", "AppendBlob".
    :vartype blob_type: str or ~azure.storage.blob.models.BlobType
    :ivar lease_status: Possible values include: "locked", "unlocked".
    :vartype lease_status: str or ~azure.storage.blob.models.LeaseStatusType
    :ivar lease_state: Possible values include: "available", "leased", "expired", "breaking",
     "broken".
    :vartype lease_state: str or ~azure.storage.blob.models.LeaseStateType
    :ivar lease_duration: Possible values include: "infinite", "fixed".
    :vartype lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
    :ivar copy_id:
    :vartype copy_id: str
    :ivar copy_status: Possible values include: "pending", "success", "aborted", "failed".
    :vartype copy_status: str or ~azure.storage.blob.models.CopyStatusType
    :ivar copy_source:
    :vartype copy_source: str
    :ivar copy_progress:
    :vartype copy_progress: str
    :ivar copy_completion_time:
    :vartype copy_completion_time: ~datetime.datetime
    :ivar copy_status_description:
    :vartype copy_status_description: str
    :ivar server_encrypted:
    :vartype server_encrypted: bool
    :ivar incremental_copy:
    :vartype incremental_copy: bool
    :ivar destination_snapshot:
    :vartype destination_snapshot: str
    :ivar deleted_time:
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days:
    :vartype remaining_retention_days: int
    :ivar access_tier: Possible values include: "P4", "P6", "P10", "P15", "P20", "P30", "P40",
     "P50", "P60", "P70", "P80", "Hot", "Cool", "Archive".
    :vartype access_tier: str or ~azure.storage.blob.models.AccessTier
    :ivar access_tier_inferred:
    :vartype access_tier_inferred: bool
    :ivar archive_status: Possible values include: "rehydrate-pending-to-hot",
     "rehydrate-pending-to-cool".
    :vartype archive_status: str or ~azure.storage.blob.models.ArchiveStatus
    :ivar customer_provided_key_sha256:
    :vartype customer_provided_key_sha256: str
    :ivar encryption_scope: The name of the encryption scope under which the blob is encrypted.
    :vartype encryption_scope: str
    :ivar access_tier_change_time:
    :vartype access_tier_change_time: ~datetime.datetime
    :ivar tag_count:
    :vartype tag_count: int
    :ivar expires_on:
    :vartype expires_on: ~datetime.datetime
    :ivar is_sealed:
    :vartype is_sealed: bool
    :ivar rehydrate_priority: If an object is in rehydrate pending state then this header is
     returned with priority of rehydrate. Valid values are High and Standard. Possible values
     include: "High", "Standard".
    :vartype rehydrate_priority: str or ~azure.storage.blob.models.RehydratePriority
    :ivar last_accessed_on:
    :vartype last_accessed_on: ~datetime.datetime
    :ivar immutability_policy_expires_on:
    :vartype immutability_policy_expires_on: ~datetime.datetime
    :ivar immutability_policy_mode: Possible values include: "Mutable", "Unlocked", "Locked".
    :vartype immutability_policy_mode: str or ~azure.storage.blob.models.BlobImmutabilityPolicyMode
    :ivar legal_hold:
    :vartype legal_hold: bool
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'Creation-Time', 'type': 'rfc-1123'},
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123'},
        'etag': {'key': 'Etag', 'type': 'str'},
        'content_length': {'key': 'Content-Length', 'type': 'long'},
        'content_type': {'key': 'Content-Type', 'type': 'str'},
        'content_encoding': {'key': 'Content-Encoding', 'type': 'str'},
        'content_language': {'key': 'Content-Language', 'type': 'str'},
        'content_md5': {'key': 'Content-MD5', 'type': 'bytearray'},
        'content_disposition': {'key': 'Content-Disposition', 'type': 'str'},
        'cache_control': {'key': 'Cache-Control', 'type': 'str'},
        'blob_sequence_number': {'key': 'x-ms-blob-sequence-number', 'type': 'long'},
        'blob_type': {'key': 'BlobType', 'type': 'str'},
        'lease_status': {'key': 'LeaseStatus', 'type': 'str'},
        'lease_state': {'key': 'LeaseState', 'type': 'str'},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'str'},
        'copy_id': {'key': 'CopyId', 'type': 'str'},
        'copy_status': {'key': 'CopyStatus', 'type': 'str'},
        'copy_source': {'key': 'CopySource', 'type': 'str'},
        'copy_progress': {'key': 'CopyProgress', 'type': 'str'},
        'copy_completion_time': {'key': 'CopyCompletionTime', 'type': 'rfc-1123'},
        'copy_status_description': {'key': 'CopyStatusDescription', 'type': 'str'},
        'server_encrypted': {'key': 'ServerEncrypted', 'type': 'bool'},
        'incremental_copy': {'key': 'IncrementalCopy', 'type': 'bool'},
        'destination_snapshot': {'key': 'DestinationSnapshot', 'type': 'str'},
        'deleted_time': {'key': 'DeletedTime', 'type': 'rfc-1123'},
        'remaining_retention_days': {'key': 'RemainingRetentionDays', 'type': 'int'},
        'access_tier': {'key': 'AccessTier', 'type': 'str'},
        'access_tier_inferred': {'key': 'AccessTierInferred', 'type': 'bool'},
        'archive_status': {'key': 'ArchiveStatus', 'type': 'str'},
        'customer_provided_key_sha256': {'key': 'CustomerProvidedKeySha256', 'type': 'str'},
        'encryption_scope': {'key': 'EncryptionScope', 'type': 'str'},
        'access_tier_change_time': {'key': 'AccessTierChangeTime', 'type': 'rfc-1123'},
        'tag_count': {'key': 'TagCount', 'type': 'int'},
        'expires_on': {'key': 'Expiry-Time', 'type': 'rfc-1123'},
        'is_sealed': {'key': 'Sealed', 'type': 'bool'},
        'rehydrate_priority': {'key': 'RehydratePriority', 'type': 'str'},
        'last_accessed_on': {'key': 'LastAccessTime', 'type': 'rfc-1123'},
        'immutability_policy_expires_on': {'key': 'ImmutabilityPolicyUntilDate', 'type': 'rfc-1123'},
        'immutability_policy_mode': {'key': 'ImmutabilityPolicyMode', 'type': 'str'},
        'legal_hold': {'key': 'LegalHold', 'type': 'bool'},
    }
    _xml_map = {
        'name': 'Properties'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword creation_time:
        :paramtype creation_time: ~datetime.datetime
        :keyword last_modified: Required.
        :paramtype last_modified: ~datetime.datetime
        :keyword etag: Required.
        :paramtype etag: str
        :keyword content_length: Size in bytes.
        :paramtype content_length: long
        :keyword content_type:
        :paramtype content_type: str
        :keyword content_encoding:
        :paramtype content_encoding: str
        :keyword content_language:
        :paramtype content_language: str
        :keyword content_md5:
        :paramtype content_md5: bytearray
        :keyword content_disposition:
        :paramtype content_disposition: str
        :keyword cache_control:
        :paramtype cache_control: str
        :keyword blob_sequence_number:
        :paramtype blob_sequence_number: long
        :keyword blob_type: Possible values include: "BlockBlob", "PageBlob", "AppendBlob".
        :paramtype blob_type: str or ~azure.storage.blob.models.BlobType
        :keyword lease_status: Possible values include: "locked", "unlocked".
        :paramtype lease_status: str or ~azure.storage.blob.models.LeaseStatusType
        :keyword lease_state: Possible values include: "available", "leased", "expired", "breaking",
         "broken".
        :paramtype lease_state: str or ~azure.storage.blob.models.LeaseStateType
        :keyword lease_duration: Possible values include: "infinite", "fixed".
        :paramtype lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
        :keyword copy_id:
        :paramtype copy_id: str
        :keyword copy_status: Possible values include: "pending", "success", "aborted", "failed".
        :paramtype copy_status: str or ~azure.storage.blob.models.CopyStatusType
        :keyword copy_source:
        :paramtype copy_source: str
        :keyword copy_progress:
        :paramtype copy_progress: str
        :keyword copy_completion_time:
        :paramtype copy_completion_time: ~datetime.datetime
        :keyword copy_status_description:
        :paramtype copy_status_description: str
        :keyword server_encrypted:
        :paramtype server_encrypted: bool
        :keyword incremental_copy:
        :paramtype incremental_copy: bool
        :keyword destination_snapshot:
        :paramtype destination_snapshot: str
        :keyword deleted_time:
        :paramtype deleted_time: ~datetime.datetime
        :keyword remaining_retention_days:
        :paramtype remaining_retention_days: int
        :keyword access_tier: Possible values include: "P4", "P6", "P10", "P15", "P20", "P30", "P40",
         "P50", "P60", "P70", "P80", "Hot", "Cool", "Archive".
        :paramtype access_tier: str or ~azure.storage.blob.models.AccessTier
        :keyword access_tier_inferred:
        :paramtype access_tier_inferred: bool
        :keyword archive_status: Possible values include: "rehydrate-pending-to-hot",
         "rehydrate-pending-to-cool".
        :paramtype archive_status: str or ~azure.storage.blob.models.ArchiveStatus
        :keyword customer_provided_key_sha256:
        :paramtype customer_provided_key_sha256: str
        :keyword encryption_scope: The name of the encryption scope under which the blob is encrypted.
        :paramtype encryption_scope: str
        :keyword access_tier_change_time:
        :paramtype access_tier_change_time: ~datetime.datetime
        :keyword tag_count:
        :paramtype tag_count: int
        :keyword expires_on:
        :paramtype expires_on: ~datetime.datetime
        :keyword is_sealed:
        :paramtype is_sealed: bool
        :keyword rehydrate_priority: If an object is in rehydrate pending state then this header is
         returned with priority of rehydrate. Valid values are High and Standard. Possible values
         include: "High", "Standard".
        :paramtype rehydrate_priority: str or ~azure.storage.blob.models.RehydratePriority
        :keyword last_accessed_on:
        :paramtype last_accessed_on: ~datetime.datetime
        :keyword immutability_policy_expires_on:
        :paramtype immutability_policy_expires_on: ~datetime.datetime
        :keyword immutability_policy_mode: Possible values include: "Mutable", "Unlocked", "Locked".
        :paramtype immutability_policy_mode: str or
         ~azure.storage.blob.models.BlobImmutabilityPolicyMode
        :keyword legal_hold:
        :paramtype legal_hold: bool
        """
        super(BlobPropertiesInternal, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.last_modified = kwargs['last_modified']
        self.etag = kwargs['etag']
        self.content_length = kwargs.get('content_length', None)
        self.content_type = kwargs.get('content_type', None)
        self.content_encoding = kwargs.get('content_encoding', None)
        self.content_language = kwargs.get('content_language', None)
        self.content_md5 = kwargs.get('content_md5', None)
        self.content_disposition = kwargs.get('content_disposition', None)
        self.cache_control = kwargs.get('cache_control', None)
        self.blob_sequence_number = kwargs.get('blob_sequence_number', None)
        self.blob_type = kwargs.get('blob_type', None)
        self.lease_status = kwargs.get('lease_status', None)
        self.lease_state = kwargs.get('lease_state', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.copy_id = kwargs.get('copy_id', None)
        self.copy_status = kwargs.get('copy_status', None)
        self.copy_source = kwargs.get('copy_source', None)
        self.copy_progress = kwargs.get('copy_progress', None)
        self.copy_completion_time = kwargs.get('copy_completion_time', None)
        self.copy_status_description = kwargs.get('copy_status_description', None)
        self.server_encrypted = kwargs.get('server_encrypted', None)
        self.incremental_copy = kwargs.get('incremental_copy', None)
        self.destination_snapshot = kwargs.get('destination_snapshot', None)
        self.deleted_time = kwargs.get('deleted_time', None)
        self.remaining_retention_days = kwargs.get('remaining_retention_days', None)
        self.access_tier = kwargs.get('access_tier', None)
        self.access_tier_inferred = kwargs.get('access_tier_inferred', None)
        self.archive_status = kwargs.get('archive_status', None)
        self.customer_provided_key_sha256 = kwargs.get('customer_provided_key_sha256', None)
        self.encryption_scope = kwargs.get('encryption_scope', None)
        self.access_tier_change_time = kwargs.get('access_tier_change_time', None)
        self.tag_count = kwargs.get('tag_count', None)
        self.expires_on = kwargs.get('expires_on', None)
        self.is_sealed = kwargs.get('is_sealed', None)
        self.rehydrate_priority = kwargs.get('rehydrate_priority', None)
        self.last_accessed_on = kwargs.get('last_accessed_on', None)
        self.immutability_policy_expires_on = kwargs.get('immutability_policy_expires_on', None)
        self.immutability_policy_mode = kwargs.get('immutability_policy_mode', None)
        self.legal_hold = kwargs.get('legal_hold', None)


class BlobTag(msrest.serialization.Model):
    """BlobTag.

    All required parameters must be populated in order to send to Azure.

    :ivar key: Required.
    :vartype key: str
    :ivar value: Required.
    :vartype value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }
    _xml_map = {
        'name': 'Tag'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key: Required.
        :paramtype key: str
        :keyword value: Required.
        :paramtype value: str
        """
        super(BlobTag, self).__init__(**kwargs)
        self.key = kwargs['key']
        self.value = kwargs['value']


class BlobTags(msrest.serialization.Model):
    """Blob tags.

    All required parameters must be populated in order to send to Azure.

    :ivar blob_tag_set: Required.
    :vartype blob_tag_set: list[~azure.storage.blob.models.BlobTag]
    """

    _validation = {
        'blob_tag_set': {'required': True},
    }

    _attribute_map = {
        'blob_tag_set': {'key': 'BlobTagSet', 'type': '[BlobTag]', 'xml': {'name': 'TagSet', 'wrapped': True, 'itemsName': 'Tag'}},
    }
    _xml_map = {
        'name': 'Tags'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword blob_tag_set: Required.
        :paramtype blob_tag_set: list[~azure.storage.blob.models.BlobTag]
        """
        super(BlobTags, self).__init__(**kwargs)
        self.blob_tag_set = kwargs['blob_tag_set']


class Block(msrest.serialization.Model):
    """Represents a single block in a block blob.  It describes the block's ID and size.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The base64 encoded block ID.
    :vartype name: str
    :ivar size: Required. The block size in bytes.
    :vartype size: long
    """

    _validation = {
        'name': {'required': True},
        'size': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'size': {'key': 'Size', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The base64 encoded block ID.
        :paramtype name: str
        :keyword size: Required. The block size in bytes.
        :paramtype size: long
        """
        super(Block, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.size = kwargs['size']


class BlockList(msrest.serialization.Model):
    """BlockList.

    :ivar committed_blocks:
    :vartype committed_blocks: list[~azure.storage.blob.models.Block]
    :ivar uncommitted_blocks:
    :vartype uncommitted_blocks: list[~azure.storage.blob.models.Block]
    """

    _attribute_map = {
        'committed_blocks': {'key': 'CommittedBlocks', 'type': '[Block]', 'xml': {'wrapped': True}},
        'uncommitted_blocks': {'key': 'UncommittedBlocks', 'type': '[Block]', 'xml': {'wrapped': True}},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword committed_blocks:
        :paramtype committed_blocks: list[~azure.storage.blob.models.Block]
        :keyword uncommitted_blocks:
        :paramtype uncommitted_blocks: list[~azure.storage.blob.models.Block]
        """
        super(BlockList, self).__init__(**kwargs)
        self.committed_blocks = kwargs.get('committed_blocks', None)
        self.uncommitted_blocks = kwargs.get('uncommitted_blocks', None)


class BlockLookupList(msrest.serialization.Model):
    """BlockLookupList.

    :ivar committed:
    :vartype committed: list[str]
    :ivar uncommitted:
    :vartype uncommitted: list[str]
    :ivar latest:
    :vartype latest: list[str]
    """

    _attribute_map = {
        'committed': {'key': 'Committed', 'type': '[str]', 'xml': {'itemsName': 'Committed'}},
        'uncommitted': {'key': 'Uncommitted', 'type': '[str]', 'xml': {'itemsName': 'Uncommitted'}},
        'latest': {'key': 'Latest', 'type': '[str]', 'xml': {'itemsName': 'Latest'}},
    }
    _xml_map = {
        'name': 'BlockList'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword committed:
        :paramtype committed: list[str]
        :keyword uncommitted:
        :paramtype uncommitted: list[str]
        :keyword latest:
        :paramtype latest: list[str]
        """
        super(BlockLookupList, self).__init__(**kwargs)
        self.committed = kwargs.get('committed', None)
        self.uncommitted = kwargs.get('uncommitted', None)
        self.latest = kwargs.get('latest', None)


class ClearRange(msrest.serialization.Model):
    """ClearRange.

    All required parameters must be populated in order to send to Azure.

    :ivar start: Required.
    :vartype start: long
    :ivar end: Required.
    :vartype end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'ClearRange'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: Required.
        :paramtype start: long
        :keyword end: Required.
        :paramtype end: long
        """
        super(ClearRange, self).__init__(**kwargs)
        self.start = kwargs['start']
        self.end = kwargs['end']


class ContainerCpkScopeInfo(msrest.serialization.Model):
    """Parameter group.

    :ivar default_encryption_scope: Optional.  Version 2019-07-07 and later.  Specifies the default
     encryption scope to set on the container and use for all future writes.
    :vartype default_encryption_scope: str
    :ivar prevent_encryption_scope_override: Optional.  Version 2019-07-07 and newer.  If true,
     prevents any request from specifying a different encryption scope than the scope set on the
     container.
    :vartype prevent_encryption_scope_override: bool
    """

    _attribute_map = {
        'default_encryption_scope': {'key': 'DefaultEncryptionScope', 'type': 'str'},
        'prevent_encryption_scope_override': {'key': 'PreventEncryptionScopeOverride', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword default_encryption_scope: Optional.  Version 2019-07-07 and later.  Specifies the
         default encryption scope to set on the container and use for all future writes.
        :paramtype default_encryption_scope: str
        :keyword prevent_encryption_scope_override: Optional.  Version 2019-07-07 and newer.  If true,
         prevents any request from specifying a different encryption scope than the scope set on the
         container.
        :paramtype prevent_encryption_scope_override: bool
        """
        super(ContainerCpkScopeInfo, self).__init__(**kwargs)
        self.default_encryption_scope = kwargs.get('default_encryption_scope', None)
        self.prevent_encryption_scope_override = kwargs.get('prevent_encryption_scope_override', None)


class ContainerItem(msrest.serialization.Model):
    """An Azure Storage container.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar deleted:
    :vartype deleted: bool
    :ivar version:
    :vartype version: str
    :ivar properties: Required. Properties of a container.
    :vartype properties: ~azure.storage.blob.models.ContainerProperties
    :ivar metadata: Dictionary of :code:`<string>`.
    :vartype metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'deleted': {'key': 'Deleted', 'type': 'bool'},
        'version': {'key': 'Version', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': 'ContainerProperties'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }
    _xml_map = {
        'name': 'Container'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword deleted:
        :paramtype deleted: bool
        :keyword version:
        :paramtype version: str
        :keyword properties: Required. Properties of a container.
        :paramtype properties: ~azure.storage.blob.models.ContainerProperties
        :keyword metadata: Dictionary of :code:`<string>`.
        :paramtype metadata: dict[str, str]
        """
        super(ContainerItem, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.deleted = kwargs.get('deleted', None)
        self.version = kwargs.get('version', None)
        self.properties = kwargs['properties']
        self.metadata = kwargs.get('metadata', None)


class ContainerProperties(msrest.serialization.Model):
    """Properties of a container.

    All required parameters must be populated in order to send to Azure.

    :ivar last_modified: Required.
    :vartype last_modified: ~datetime.datetime
    :ivar etag: Required.
    :vartype etag: str
    :ivar lease_status: Possible values include: "locked", "unlocked".
    :vartype lease_status: str or ~azure.storage.blob.models.LeaseStatusType
    :ivar lease_state: Possible values include: "available", "leased", "expired", "breaking",
     "broken".
    :vartype lease_state: str or ~azure.storage.blob.models.LeaseStateType
    :ivar lease_duration: Possible values include: "infinite", "fixed".
    :vartype lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
    :ivar public_access: Possible values include: "container", "blob".
    :vartype public_access: str or ~azure.storage.blob.models.PublicAccessType
    :ivar has_immutability_policy:
    :vartype has_immutability_policy: bool
    :ivar has_legal_hold:
    :vartype has_legal_hold: bool
    :ivar default_encryption_scope:
    :vartype default_encryption_scope: str
    :ivar prevent_encryption_scope_override:
    :vartype prevent_encryption_scope_override: bool
    :ivar deleted_time:
    :vartype deleted_time: ~datetime.datetime
    :ivar remaining_retention_days:
    :vartype remaining_retention_days: int
    :ivar is_immutable_storage_with_versioning_enabled: Indicates if version level worm is enabled
     on this container.
    :vartype is_immutable_storage_with_versioning_enabled: bool
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
    }

    _attribute_map = {
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123'},
        'etag': {'key': 'Etag', 'type': 'str'},
        'lease_status': {'key': 'LeaseStatus', 'type': 'str'},
        'lease_state': {'key': 'LeaseState', 'type': 'str'},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'str'},
        'public_access': {'key': 'PublicAccess', 'type': 'str'},
        'has_immutability_policy': {'key': 'HasImmutabilityPolicy', 'type': 'bool'},
        'has_legal_hold': {'key': 'HasLegalHold', 'type': 'bool'},
        'default_encryption_scope': {'key': 'DefaultEncryptionScope', 'type': 'str'},
        'prevent_encryption_scope_override': {'key': 'DenyEncryptionScopeOverride', 'type': 'bool'},
        'deleted_time': {'key': 'DeletedTime', 'type': 'rfc-1123'},
        'remaining_retention_days': {'key': 'RemainingRetentionDays', 'type': 'int'},
        'is_immutable_storage_with_versioning_enabled': {'key': 'ImmutableStorageWithVersioningEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword last_modified: Required.
        :paramtype last_modified: ~datetime.datetime
        :keyword etag: Required.
        :paramtype etag: str
        :keyword lease_status: Possible values include: "locked", "unlocked".
        :paramtype lease_status: str or ~azure.storage.blob.models.LeaseStatusType
        :keyword lease_state: Possible values include: "available", "leased", "expired", "breaking",
         "broken".
        :paramtype lease_state: str or ~azure.storage.blob.models.LeaseStateType
        :keyword lease_duration: Possible values include: "infinite", "fixed".
        :paramtype lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
        :keyword public_access: Possible values include: "container", "blob".
        :paramtype public_access: str or ~azure.storage.blob.models.PublicAccessType
        :keyword has_immutability_policy:
        :paramtype has_immutability_policy: bool
        :keyword has_legal_hold:
        :paramtype has_legal_hold: bool
        :keyword default_encryption_scope:
        :paramtype default_encryption_scope: str
        :keyword prevent_encryption_scope_override:
        :paramtype prevent_encryption_scope_override: bool
        :keyword deleted_time:
        :paramtype deleted_time: ~datetime.datetime
        :keyword remaining_retention_days:
        :paramtype remaining_retention_days: int
        :keyword is_immutable_storage_with_versioning_enabled: Indicates if version level worm is
         enabled on this container.
        :paramtype is_immutable_storage_with_versioning_enabled: bool
        """
        super(ContainerProperties, self).__init__(**kwargs)
        self.last_modified = kwargs['last_modified']
        self.etag = kwargs['etag']
        self.lease_status = kwargs.get('lease_status', None)
        self.lease_state = kwargs.get('lease_state', None)
        self.lease_duration = kwargs.get('lease_duration', None)
        self.public_access = kwargs.get('public_access', None)
        self.has_immutability_policy = kwargs.get('has_immutability_policy', None)
        self.has_legal_hold = kwargs.get('has_legal_hold', None)
        self.default_encryption_scope = kwargs.get('default_encryption_scope', None)
        self.prevent_encryption_scope_override = kwargs.get('prevent_encryption_scope_override', None)
        self.deleted_time = kwargs.get('deleted_time', None)
        self.remaining_retention_days = kwargs.get('remaining_retention_days', None)
        self.is_immutable_storage_with_versioning_enabled = kwargs.get('is_immutable_storage_with_versioning_enabled', None)


class CorsRule(msrest.serialization.Model):
    """CORS is an HTTP feature that enables a web application running under one domain to access resources in another domain. Web browsers implement a security restriction known as same-origin policy that prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required. The origin domains that are permitted to make a request
     against the storage service via CORS. The origin domain is the domain from which the request
     originates. Note that the origin must be an exact case-sensitive match with the origin that the
     user age sends to the service. You can also use the wildcard character '*' to allow all origin
     domains to make requests via CORS.
    :vartype allowed_origins: str
    :ivar allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
     use for a CORS request. (comma separated).
    :vartype allowed_methods: str
    :ivar allowed_headers: Required. the request headers that the origin domain may specify on the
     CORS request.
    :vartype allowed_headers: str
    :ivar exposed_headers: Required. The response headers that may be sent in the response to the
     CORS request and exposed by the browser to the request issuer.
    :vartype exposed_headers: str
    :ivar max_age_in_seconds: Required. The maximum amount time that a browser should cache the
     preflight OPTIONS request.
    :vartype max_age_in_seconds: int
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'allowed_headers': {'required': True},
        'exposed_headers': {'required': True},
        'max_age_in_seconds': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'AllowedOrigins', 'type': 'str'},
        'allowed_methods': {'key': 'AllowedMethods', 'type': 'str'},
        'allowed_headers': {'key': 'AllowedHeaders', 'type': 'str'},
        'exposed_headers': {'key': 'ExposedHeaders', 'type': 'str'},
        'max_age_in_seconds': {'key': 'MaxAgeInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword allowed_origins: Required. The origin domains that are permitted to make a request
         against the storage service via CORS. The origin domain is the domain from which the request
         originates. Note that the origin must be an exact case-sensitive match with the origin that the
         user age sends to the service. You can also use the wildcard character '*' to allow all origin
         domains to make requests via CORS.
        :paramtype allowed_origins: str
        :keyword allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
         use for a CORS request. (comma separated).
        :paramtype allowed_methods: str
        :keyword allowed_headers: Required. the request headers that the origin domain may specify on
         the CORS request.
        :paramtype allowed_headers: str
        :keyword exposed_headers: Required. The response headers that may be sent in the response to
         the CORS request and exposed by the browser to the request issuer.
        :paramtype exposed_headers: str
        :keyword max_age_in_seconds: Required. The maximum amount time that a browser should cache the
         preflight OPTIONS request.
        :paramtype max_age_in_seconds: int
        """
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs['allowed_origins']
        self.allowed_methods = kwargs['allowed_methods']
        self.allowed_headers = kwargs['allowed_headers']
        self.exposed_headers = kwargs['exposed_headers']
        self.max_age_in_seconds = kwargs['max_age_in_seconds']


class CpkInfo(msrest.serialization.Model):
    """Parameter group.

    :ivar encryption_key: Optional. Specifies the encryption key to use to encrypt the data
     provided in the request. If not specified, encryption is performed with the root account
     encryption key.  For more information, see Encryption at Rest for Azure Storage Services.
    :vartype encryption_key: str
    :ivar encryption_key_sha256: The SHA-256 hash of the provided encryption key. Must be provided
     if the x-ms-encryption-key header is provided.
    :vartype encryption_key_sha256: str
    :ivar encryption_algorithm: The algorithm used to produce the encryption key hash. Currently,
     the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header is
     provided. Possible values include: "None", "AES256".
    :vartype encryption_algorithm: str or ~azure.storage.blob.models.EncryptionAlgorithmType
    """

    _attribute_map = {
        'encryption_key': {'key': 'encryptionKey', 'type': 'str'},
        'encryption_key_sha256': {'key': 'encryptionKeySha256', 'type': 'str'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword encryption_key: Optional. Specifies the encryption key to use to encrypt the data
         provided in the request. If not specified, encryption is performed with the root account
         encryption key.  For more information, see Encryption at Rest for Azure Storage Services.
        :paramtype encryption_key: str
        :keyword encryption_key_sha256: The SHA-256 hash of the provided encryption key. Must be
         provided if the x-ms-encryption-key header is provided.
        :paramtype encryption_key_sha256: str
        :keyword encryption_algorithm: The algorithm used to produce the encryption key hash.
         Currently, the only accepted value is "AES256". Must be provided if the x-ms-encryption-key
         header is provided. Possible values include: "None", "AES256".
        :paramtype encryption_algorithm: str or ~azure.storage.blob.models.EncryptionAlgorithmType
        """
        super(CpkInfo, self).__init__(**kwargs)
        self.encryption_key = kwargs.get('encryption_key', None)
        self.encryption_key_sha256 = kwargs.get('encryption_key_sha256', None)
        self.encryption_algorithm = kwargs.get('encryption_algorithm', None)


class CpkScopeInfo(msrest.serialization.Model):
    """Parameter group.

    :ivar encryption_scope: Optional. Version 2019-07-07 and later.  Specifies the name of the
     encryption scope to use to encrypt the data provided in the request. If not specified,
     encryption is performed with the default account encryption scope.  For more information, see
     Encryption at Rest for Azure Storage Services.
    :vartype encryption_scope: str
    """

    _attribute_map = {
        'encryption_scope': {'key': 'encryptionScope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword encryption_scope: Optional. Version 2019-07-07 and later.  Specifies the name of the
         encryption scope to use to encrypt the data provided in the request. If not specified,
         encryption is performed with the default account encryption scope.  For more information, see
         Encryption at Rest for Azure Storage Services.
        :paramtype encryption_scope: str
        """
        super(CpkScopeInfo, self).__init__(**kwargs)
        self.encryption_scope = kwargs.get('encryption_scope', None)


class DelimitedTextConfiguration(msrest.serialization.Model):
    """Groups the settings used for interpreting the blob data if the blob is delimited text formatted.

    :ivar column_separator: The string used to separate columns.
    :vartype column_separator: str
    :ivar field_quote: The string used to quote a specific field.
    :vartype field_quote: str
    :ivar record_separator: The string used to separate records.
    :vartype record_separator: str
    :ivar escape_char: The string used as an escape character.
    :vartype escape_char: str
    :ivar headers_present: Represents whether the data has headers.
    :vartype headers_present: bool
    """

    _attribute_map = {
        'column_separator': {'key': 'ColumnSeparator', 'type': 'str', 'xml': {'name': 'ColumnSeparator'}},
        'field_quote': {'key': 'FieldQuote', 'type': 'str', 'xml': {'name': 'FieldQuote'}},
        'record_separator': {'key': 'RecordSeparator', 'type': 'str', 'xml': {'name': 'RecordSeparator'}},
        'escape_char': {'key': 'EscapeChar', 'type': 'str', 'xml': {'name': 'EscapeChar'}},
        'headers_present': {'key': 'HeadersPresent', 'type': 'bool', 'xml': {'name': 'HasHeaders'}},
    }
    _xml_map = {
        'name': 'DelimitedTextConfiguration'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword column_separator: The string used to separate columns.
        :paramtype column_separator: str
        :keyword field_quote: The string used to quote a specific field.
        :paramtype field_quote: str
        :keyword record_separator: The string used to separate records.
        :paramtype record_separator: str
        :keyword escape_char: The string used as an escape character.
        :paramtype escape_char: str
        :keyword headers_present: Represents whether the data has headers.
        :paramtype headers_present: bool
        """
        super(DelimitedTextConfiguration, self).__init__(**kwargs)
        self.column_separator = kwargs.get('column_separator', None)
        self.field_quote = kwargs.get('field_quote', None)
        self.record_separator = kwargs.get('record_separator', None)
        self.escape_char = kwargs.get('escape_char', None)
        self.headers_present = kwargs.get('headers_present', None)


class FilterBlobItem(msrest.serialization.Model):
    """Blob info from a Filter Blobs API call.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    :ivar container_name: Required.
    :vartype container_name: str
    :ivar tags: A set of tags. Blob tags.
    :vartype tags: ~azure.storage.blob.models.BlobTags
    """

    _validation = {
        'name': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'container_name': {'key': 'ContainerName', 'type': 'str'},
        'tags': {'key': 'Tags', 'type': 'BlobTags'},
    }
    _xml_map = {
        'name': 'Blob'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword container_name: Required.
        :paramtype container_name: str
        :keyword tags: A set of tags. Blob tags.
        :paramtype tags: ~azure.storage.blob.models.BlobTags
        """
        super(FilterBlobItem, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.container_name = kwargs['container_name']
        self.tags = kwargs.get('tags', None)


class FilterBlobSegment(msrest.serialization.Model):
    """The result of a Filter Blobs API call.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar where: Required.
    :vartype where: str
    :ivar blobs: Required.
    :vartype blobs: list[~azure.storage.blob.models.FilterBlobItem]
    :ivar next_marker:
    :vartype next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'where': {'required': True},
        'blobs': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'where': {'key': 'Where', 'type': 'str'},
        'blobs': {'key': 'Blobs', 'type': '[FilterBlobItem]', 'xml': {'name': 'Blobs', 'wrapped': True, 'itemsName': 'Blob'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword where: Required.
        :paramtype where: str
        :keyword blobs: Required.
        :paramtype blobs: list[~azure.storage.blob.models.FilterBlobItem]
        :keyword next_marker:
        :paramtype next_marker: str
        """
        super(FilterBlobSegment, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.where = kwargs['where']
        self.blobs = kwargs['blobs']
        self.next_marker = kwargs.get('next_marker', None)


class GeoReplication(msrest.serialization.Model):
    """Geo-Replication information for the Secondary Storage Service.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The status of the secondary location. Possible values include: "live",
     "bootstrap", "unavailable".
    :vartype status: str or ~azure.storage.blob.models.GeoReplicationStatusType
    :ivar last_sync_time: Required. A GMT date/time value, to the second. All primary writes
     preceding this value are guaranteed to be available for read operations at the secondary.
     Primary writes after this point in time may or may not be available for reads.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        'status': {'required': True},
        'last_sync_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'str'},
        'last_sync_time': {'key': 'LastSyncTime', 'type': 'rfc-1123'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword status: Required. The status of the secondary location. Possible values include:
         "live", "bootstrap", "unavailable".
        :paramtype status: str or ~azure.storage.blob.models.GeoReplicationStatusType
        :keyword last_sync_time: Required. A GMT date/time value, to the second. All primary writes
         preceding this value are guaranteed to be available for read operations at the secondary.
         Primary writes after this point in time may or may not be available for reads.
        :paramtype last_sync_time: ~datetime.datetime
        """
        super(GeoReplication, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.last_sync_time = kwargs['last_sync_time']


class JsonTextConfiguration(msrest.serialization.Model):
    """json text configuration.

    :ivar record_separator: The string used to separate records.
    :vartype record_separator: str
    """

    _attribute_map = {
        'record_separator': {'key': 'RecordSeparator', 'type': 'str', 'xml': {'name': 'RecordSeparator'}},
    }
    _xml_map = {
        'name': 'JsonTextConfiguration'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword record_separator: The string used to separate records.
        :paramtype record_separator: str
        """
        super(JsonTextConfiguration, self).__init__(**kwargs)
        self.record_separator = kwargs.get('record_separator', None)


class KeyInfo(msrest.serialization.Model):
    """Key information.

    All required parameters must be populated in order to send to Azure.

    :ivar start: Required. The date-time the key is active in ISO 8601 UTC time.
    :vartype start: str
    :ivar expiry: Required. The date-time the key expires in ISO 8601 UTC time.
    :vartype expiry: str
    """

    _validation = {
        'start': {'required': True},
        'expiry': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str'},
        'expiry': {'key': 'Expiry', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: Required. The date-time the key is active in ISO 8601 UTC time.
        :paramtype start: str
        :keyword expiry: Required. The date-time the key expires in ISO 8601 UTC time.
        :paramtype expiry: str
        """
        super(KeyInfo, self).__init__(**kwargs)
        self.start = kwargs['start']
        self.expiry = kwargs['expiry']


class LeaseAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar lease_id: If specified, the operation only succeeds if the resource's lease is active and
     matches this ID.
    :vartype lease_id: str
    """

    _attribute_map = {
        'lease_id': {'key': 'leaseId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword lease_id: If specified, the operation only succeeds if the resource's lease is active
         and matches this ID.
        :paramtype lease_id: str
        """
        super(LeaseAccessConditions, self).__init__(**kwargs)
        self.lease_id = kwargs.get('lease_id', None)


class ListBlobsFlatSegmentResponse(msrest.serialization.Model):
    """An enumeration of blobs.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar container_name: Required.
    :vartype container_name: str
    :ivar prefix:
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results:
    :vartype max_results: int
    :ivar segment: Required.
    :vartype segment: ~azure.storage.blob.models.BlobFlatListSegment
    :ivar next_marker:
    :vartype next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_name': {'required': True},
        'segment': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'segment': {'key': 'Segment', 'type': 'BlobFlatListSegment'},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword container_name: Required.
        :paramtype container_name: str
        :keyword prefix:
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results:
        :paramtype max_results: int
        :keyword segment: Required.
        :paramtype segment: ~azure.storage.blob.models.BlobFlatListSegment
        :keyword next_marker:
        :paramtype next_marker: str
        """
        super(ListBlobsFlatSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.container_name = kwargs['container_name']
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.segment = kwargs['segment']
        self.next_marker = kwargs.get('next_marker', None)


class ListBlobsHierarchySegmentResponse(msrest.serialization.Model):
    """An enumeration of blobs.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar container_name: Required.
    :vartype container_name: str
    :ivar prefix:
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results:
    :vartype max_results: int
    :ivar delimiter:
    :vartype delimiter: str
    :ivar segment: Required.
    :vartype segment: ~azure.storage.blob.models.BlobHierarchyListSegment
    :ivar next_marker:
    :vartype next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_name': {'required': True},
        'segment': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'delimiter': {'key': 'Delimiter', 'type': 'str'},
        'segment': {'key': 'Segment', 'type': 'BlobHierarchyListSegment'},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword container_name: Required.
        :paramtype container_name: str
        :keyword prefix:
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results:
        :paramtype max_results: int
        :keyword delimiter:
        :paramtype delimiter: str
        :keyword segment: Required.
        :paramtype segment: ~azure.storage.blob.models.BlobHierarchyListSegment
        :keyword next_marker:
        :paramtype next_marker: str
        """
        super(ListBlobsHierarchySegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.container_name = kwargs['container_name']
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.delimiter = kwargs.get('delimiter', None)
        self.segment = kwargs['segment']
        self.next_marker = kwargs.get('next_marker', None)


class ListContainersSegmentResponse(msrest.serialization.Model):
    """An enumeration of containers.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar prefix:
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results:
    :vartype max_results: int
    :ivar container_items: Required.
    :vartype container_items: list[~azure.storage.blob.models.ContainerItem]
    :ivar next_marker:
    :vartype next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_items': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'container_items': {'key': 'ContainerItems', 'type': '[ContainerItem]', 'xml': {'name': 'Containers', 'wrapped': True, 'itemsName': 'Container'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword prefix:
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results:
        :paramtype max_results: int
        :keyword container_items: Required.
        :paramtype container_items: list[~azure.storage.blob.models.ContainerItem]
        :keyword next_marker:
        :paramtype next_marker: str
        """
        super(ListContainersSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.prefix = kwargs.get('prefix', None)
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs.get('max_results', None)
        self.container_items = kwargs['container_items']
        self.next_marker = kwargs.get('next_marker', None)


class Logging(msrest.serialization.Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Required. The version of Storage Analytics to configure.
    :vartype version: str
    :ivar delete: Required. Indicates whether all delete requests should be logged.
    :vartype delete: bool
    :ivar read: Required. Indicates whether all read requests should be logged.
    :vartype read: bool
    :ivar write: Required. Indicates whether all write requests should be logged.
    :vartype write: bool
    :ivar retention_policy: Required. the retention policy which determines how long the associated
     data should persist.
    :vartype retention_policy: ~azure.storage.blob.models.RetentionPolicy
    """

    _validation = {
        'version': {'required': True},
        'delete': {'required': True},
        'read': {'required': True},
        'write': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'delete': {'key': 'Delete', 'type': 'bool'},
        'read': {'key': 'Read', 'type': 'bool'},
        'write': {'key': 'Write', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version: Required. The version of Storage Analytics to configure.
        :paramtype version: str
        :keyword delete: Required. Indicates whether all delete requests should be logged.
        :paramtype delete: bool
        :keyword read: Required. Indicates whether all read requests should be logged.
        :paramtype read: bool
        :keyword write: Required. Indicates whether all write requests should be logged.
        :paramtype write: bool
        :keyword retention_policy: Required. the retention policy which determines how long the
         associated data should persist.
        :paramtype retention_policy: ~azure.storage.blob.models.RetentionPolicy
        """
        super(Logging, self).__init__(**kwargs)
        self.version = kwargs['version']
        self.delete = kwargs['delete']
        self.read = kwargs['read']
        self.write = kwargs['write']
        self.retention_policy = kwargs['retention_policy']


class Metrics(msrest.serialization.Model):
    """a summary of request statistics grouped by API in hour or minute aggregates for blobs.

    All required parameters must be populated in order to send to Azure.

    :ivar version: The version of Storage Analytics to configure.
    :vartype version: str
    :ivar enabled: Required. Indicates whether metrics are enabled for the Blob service.
    :vartype enabled: bool
    :ivar include_apis: Indicates whether metrics should generate summary statistics for called API
     operations.
    :vartype include_apis: bool
    :ivar retention_policy: the retention policy which determines how long the associated data
     should persist.
    :vartype retention_policy: ~azure.storage.blob.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'include_apis': {'key': 'IncludeAPIs', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version: The version of Storage Analytics to configure.
        :paramtype version: str
        :keyword enabled: Required. Indicates whether metrics are enabled for the Blob service.
        :paramtype enabled: bool
        :keyword include_apis: Indicates whether metrics should generate summary statistics for called
         API operations.
        :paramtype include_apis: bool
        :keyword retention_policy: the retention policy which determines how long the associated data
         should persist.
        :paramtype retention_policy: ~azure.storage.blob.models.RetentionPolicy
        """
        super(Metrics, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.enabled = kwargs['enabled']
        self.include_apis = kwargs.get('include_apis', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class ModifiedAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar if_modified_since: Specify this header value to operate only on a blob if it has been
     modified since the specified date/time.
    :vartype if_modified_since: ~datetime.datetime
    :ivar if_unmodified_since: Specify this header value to operate only on a blob if it has not
     been modified since the specified date/time.
    :vartype if_unmodified_since: ~datetime.datetime
    :ivar if_match: Specify an ETag value to operate only on blobs with a matching value.
    :vartype if_match: str
    :ivar if_none_match: Specify an ETag value to operate only on blobs without a matching value.
    :vartype if_none_match: str
    :ivar if_tags: Specify a SQL where clause on blob tags to operate only on blobs with a matching
     value.
    :vartype if_tags: str
    """

    _attribute_map = {
        'if_modified_since': {'key': 'ifModifiedSince', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': 'ifUnmodifiedSince', 'type': 'rfc-1123'},
        'if_match': {'key': 'ifMatch', 'type': 'str'},
        'if_none_match': {'key': 'ifNoneMatch', 'type': 'str'},
        'if_tags': {'key': 'ifTags', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword if_modified_since: Specify this header value to operate only on a blob if it has been
         modified since the specified date/time.
        :paramtype if_modified_since: ~datetime.datetime
        :keyword if_unmodified_since: Specify this header value to operate only on a blob if it has not
         been modified since the specified date/time.
        :paramtype if_unmodified_since: ~datetime.datetime
        :keyword if_match: Specify an ETag value to operate only on blobs with a matching value.
        :paramtype if_match: str
        :keyword if_none_match: Specify an ETag value to operate only on blobs without a matching
         value.
        :paramtype if_none_match: str
        :keyword if_tags: Specify a SQL where clause on blob tags to operate only on blobs with a
         matching value.
        :paramtype if_tags: str
        """
        super(ModifiedAccessConditions, self).__init__(**kwargs)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_tags = kwargs.get('if_tags', None)


class PageList(msrest.serialization.Model):
    """the list of pages.

    :ivar page_range:
    :vartype page_range: list[~azure.storage.blob.models.PageRange]
    :ivar clear_range:
    :vartype clear_range: list[~azure.storage.blob.models.ClearRange]
    """

    _attribute_map = {
        'page_range': {'key': 'PageRange', 'type': '[PageRange]'},
        'clear_range': {'key': 'ClearRange', 'type': '[ClearRange]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword page_range:
        :paramtype page_range: list[~azure.storage.blob.models.PageRange]
        :keyword clear_range:
        :paramtype clear_range: list[~azure.storage.blob.models.ClearRange]
        """
        super(PageList, self).__init__(**kwargs)
        self.page_range = kwargs.get('page_range', None)
        self.clear_range = kwargs.get('clear_range', None)


class PageRange(msrest.serialization.Model):
    """PageRange.

    All required parameters must be populated in order to send to Azure.

    :ivar start: Required.
    :vartype start: long
    :ivar end: Required.
    :vartype end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'PageRange'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: Required.
        :paramtype start: long
        :keyword end: Required.
        :paramtype end: long
        """
        super(PageRange, self).__init__(**kwargs)
        self.start = kwargs['start']
        self.end = kwargs['end']


class QueryFormat(msrest.serialization.Model):
    """QueryFormat.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The quick query format type. Possible values include: "delimited",
     "json", "arrow", "parquet".
    :vartype type: str or ~azure.storage.blob.models.QueryFormatType
    :ivar delimited_text_configuration: Groups the settings used for interpreting the blob data if
     the blob is delimited text formatted.
    :vartype delimited_text_configuration: ~azure.storage.blob.models.DelimitedTextConfiguration
    :ivar json_text_configuration: json text configuration.
    :vartype json_text_configuration: ~azure.storage.blob.models.JsonTextConfiguration
    :ivar arrow_configuration: Groups the settings used for formatting the response if the response
     should be Arrow formatted.
    :vartype arrow_configuration: ~azure.storage.blob.models.ArrowConfiguration
    :ivar parquet_text_configuration: Any object.
    :vartype parquet_text_configuration: any
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str', 'xml': {'name': 'Type'}},
        'delimited_text_configuration': {'key': 'DelimitedTextConfiguration', 'type': 'DelimitedTextConfiguration'},
        'json_text_configuration': {'key': 'JsonTextConfiguration', 'type': 'JsonTextConfiguration'},
        'arrow_configuration': {'key': 'ArrowConfiguration', 'type': 'ArrowConfiguration'},
        'parquet_text_configuration': {'key': 'ParquetTextConfiguration', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword type: Required. The quick query format type. Possible values include: "delimited",
         "json", "arrow", "parquet".
        :paramtype type: str or ~azure.storage.blob.models.QueryFormatType
        :keyword delimited_text_configuration: Groups the settings used for interpreting the blob data
         if the blob is delimited text formatted.
        :paramtype delimited_text_configuration: ~azure.storage.blob.models.DelimitedTextConfiguration
        :keyword json_text_configuration: json text configuration.
        :paramtype json_text_configuration: ~azure.storage.blob.models.JsonTextConfiguration
        :keyword arrow_configuration: Groups the settings used for formatting the response if the
         response should be Arrow formatted.
        :paramtype arrow_configuration: ~azure.storage.blob.models.ArrowConfiguration
        :keyword parquet_text_configuration: Any object.
        :paramtype parquet_text_configuration: any
        """
        super(QueryFormat, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.delimited_text_configuration = kwargs.get('delimited_text_configuration', None)
        self.json_text_configuration = kwargs.get('json_text_configuration', None)
        self.arrow_configuration = kwargs.get('arrow_configuration', None)
        self.parquet_text_configuration = kwargs.get('parquet_text_configuration', None)


class QueryRequest(msrest.serialization.Model):
    """Groups the set of query request settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar query_type: Required. The type of the provided query expression. Has constant value:
     "SQL".
    :vartype query_type: str
    :ivar expression: Required. The query expression in SQL. The maximum size of the query
     expression is 256KiB.
    :vartype expression: str
    :ivar input_serialization:
    :vartype input_serialization: ~azure.storage.blob.models.QuerySerialization
    :ivar output_serialization:
    :vartype output_serialization: ~azure.storage.blob.models.QuerySerialization
    """

    _validation = {
        'query_type': {'required': True, 'constant': True},
        'expression': {'required': True},
    }

    _attribute_map = {
        'query_type': {'key': 'QueryType', 'type': 'str', 'xml': {'name': 'QueryType'}},
        'expression': {'key': 'Expression', 'type': 'str', 'xml': {'name': 'Expression'}},
        'input_serialization': {'key': 'InputSerialization', 'type': 'QuerySerialization'},
        'output_serialization': {'key': 'OutputSerialization', 'type': 'QuerySerialization'},
    }
    _xml_map = {
        'name': 'QueryRequest'
    }

    query_type = "SQL"

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword expression: Required. The query expression in SQL. The maximum size of the query
         expression is 256KiB.
        :paramtype expression: str
        :keyword input_serialization:
        :paramtype input_serialization: ~azure.storage.blob.models.QuerySerialization
        :keyword output_serialization:
        :paramtype output_serialization: ~azure.storage.blob.models.QuerySerialization
        """
        super(QueryRequest, self).__init__(**kwargs)
        self.expression = kwargs['expression']
        self.input_serialization = kwargs.get('input_serialization', None)
        self.output_serialization = kwargs.get('output_serialization', None)


class QuerySerialization(msrest.serialization.Model):
    """QuerySerialization.

    All required parameters must be populated in order to send to Azure.

    :ivar format: Required.
    :vartype format: ~azure.storage.blob.models.QueryFormat
    """

    _validation = {
        'format': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'Format', 'type': 'QueryFormat'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword format: Required.
        :paramtype format: ~azure.storage.blob.models.QueryFormat
        """
        super(QuerySerialization, self).__init__(**kwargs)
        self.format = kwargs['format']


class RetentionPolicy(msrest.serialization.Model):
    """the retention policy which determines how long the associated data should persist.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Indicates whether a retention policy is enabled for the storage
     service.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that metrics or logging or soft-deleted data should be
     retained. All data older than this value will be deleted.
    :vartype days: int
    :ivar allow_permanent_delete: Indicates whether permanent delete is allowed on this storage
     account.
    :vartype allow_permanent_delete: bool
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'days': {'key': 'Days', 'type': 'int'},
        'allow_permanent_delete': {'key': 'AllowPermanentDelete', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enabled: Required. Indicates whether a retention policy is enabled for the storage
         service.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that metrics or logging or soft-deleted data should
         be retained. All data older than this value will be deleted.
        :paramtype days: int
        :keyword allow_permanent_delete: Indicates whether permanent delete is allowed on this storage
         account.
        :paramtype allow_permanent_delete: bool
        """
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs.get('days', None)
        self.allow_permanent_delete = kwargs.get('allow_permanent_delete', None)


class SequenceNumberAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar if_sequence_number_less_than_or_equal_to: Specify this header value to operate only on a
     blob if it has a sequence number less than or equal to the specified.
    :vartype if_sequence_number_less_than_or_equal_to: long
    :ivar if_sequence_number_less_than: Specify this header value to operate only on a blob if it
     has a sequence number less than the specified.
    :vartype if_sequence_number_less_than: long
    :ivar if_sequence_number_equal_to: Specify this header value to operate only on a blob if it
     has the specified sequence number.
    :vartype if_sequence_number_equal_to: long
    """

    _attribute_map = {
        'if_sequence_number_less_than_or_equal_to': {'key': 'ifSequenceNumberLessThanOrEqualTo', 'type': 'long'},
        'if_sequence_number_less_than': {'key': 'ifSequenceNumberLessThan', 'type': 'long'},
        'if_sequence_number_equal_to': {'key': 'ifSequenceNumberEqualTo', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword if_sequence_number_less_than_or_equal_to: Specify this header value to operate only on
         a blob if it has a sequence number less than or equal to the specified.
        :paramtype if_sequence_number_less_than_or_equal_to: long
        :keyword if_sequence_number_less_than: Specify this header value to operate only on a blob if
         it has a sequence number less than the specified.
        :paramtype if_sequence_number_less_than: long
        :keyword if_sequence_number_equal_to: Specify this header value to operate only on a blob if it
         has the specified sequence number.
        :paramtype if_sequence_number_equal_to: long
        """
        super(SequenceNumberAccessConditions, self).__init__(**kwargs)
        self.if_sequence_number_less_than_or_equal_to = kwargs.get('if_sequence_number_less_than_or_equal_to', None)
        self.if_sequence_number_less_than = kwargs.get('if_sequence_number_less_than', None)
        self.if_sequence_number_equal_to = kwargs.get('if_sequence_number_equal_to', None)


class SignedIdentifier(msrest.serialization.Model):
    """signed identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. a unique id.
    :vartype id: str
    :ivar access_policy: An Access policy.
    :vartype access_policy: ~azure.storage.blob.models.AccessPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'access_policy': {'key': 'AccessPolicy', 'type': 'AccessPolicy'},
    }
    _xml_map = {
        'name': 'SignedIdentifier'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. a unique id.
        :paramtype id: str
        :keyword access_policy: An Access policy.
        :paramtype access_policy: ~azure.storage.blob.models.AccessPolicy
        """
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.access_policy = kwargs.get('access_policy', None)


class SourceModifiedAccessConditions(msrest.serialization.Model):
    """Parameter group.

    :ivar source_if_modified_since: Specify this header value to operate only on a blob if it has
     been modified since the specified date/time.
    :vartype source_if_modified_since: ~datetime.datetime
    :ivar source_if_unmodified_since: Specify this header value to operate only on a blob if it has
     not been modified since the specified date/time.
    :vartype source_if_unmodified_since: ~datetime.datetime
    :ivar source_if_match: Specify an ETag value to operate only on blobs with a matching value.
    :vartype source_if_match: str
    :ivar source_if_none_match: Specify an ETag value to operate only on blobs without a matching
     value.
    :vartype source_if_none_match: str
    :ivar source_if_tags: Specify a SQL where clause on blob tags to operate only on blobs with a
     matching value.
    :vartype source_if_tags: str
    """

    _attribute_map = {
        'source_if_modified_since': {'key': 'sourceIfModifiedSince', 'type': 'rfc-1123'},
        'source_if_unmodified_since': {'key': 'sourceIfUnmodifiedSince', 'type': 'rfc-1123'},
        'source_if_match': {'key': 'sourceIfMatch', 'type': 'str'},
        'source_if_none_match': {'key': 'sourceIfNoneMatch', 'type': 'str'},
        'source_if_tags': {'key': 'sourceIfTags', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source_if_modified_since: Specify this header value to operate only on a blob if it
         has been modified since the specified date/time.
        :paramtype source_if_modified_since: ~datetime.datetime
        :keyword source_if_unmodified_since: Specify this header value to operate only on a blob if it
         has not been modified since the specified date/time.
        :paramtype source_if_unmodified_since: ~datetime.datetime
        :keyword source_if_match: Specify an ETag value to operate only on blobs with a matching value.
        :paramtype source_if_match: str
        :keyword source_if_none_match: Specify an ETag value to operate only on blobs without a
         matching value.
        :paramtype source_if_none_match: str
        :keyword source_if_tags: Specify a SQL where clause on blob tags to operate only on blobs with
         a matching value.
        :paramtype source_if_tags: str
        """
        super(SourceModifiedAccessConditions, self).__init__(**kwargs)
        self.source_if_modified_since = kwargs.get('source_if_modified_since', None)
        self.source_if_unmodified_since = kwargs.get('source_if_unmodified_since', None)
        self.source_if_match = kwargs.get('source_if_match', None)
        self.source_if_none_match = kwargs.get('source_if_none_match', None)
        self.source_if_tags = kwargs.get('source_if_tags', None)


class StaticWebsite(msrest.serialization.Model):
    """The properties that enable an account to host a static website.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Indicates whether this account is hosting a static website.
    :vartype enabled: bool
    :ivar index_document: The default name of the index page under each directory.
    :vartype index_document: str
    :ivar error_document404_path: The absolute path of the custom 404 page.
    :vartype error_document404_path: str
    :ivar default_index_document_path: Absolute path of the default index page.
    :vartype default_index_document_path: str
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'index_document': {'key': 'IndexDocument', 'type': 'str'},
        'error_document404_path': {'key': 'ErrorDocument404Path', 'type': 'str'},
        'default_index_document_path': {'key': 'DefaultIndexDocumentPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enabled: Required. Indicates whether this account is hosting a static website.
        :paramtype enabled: bool
        :keyword index_document: The default name of the index page under each directory.
        :paramtype index_document: str
        :keyword error_document404_path: The absolute path of the custom 404 page.
        :paramtype error_document404_path: str
        :keyword default_index_document_path: Absolute path of the default index page.
        :paramtype default_index_document_path: str
        """
        super(StaticWebsite, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.index_document = kwargs.get('index_document', None)
        self.error_document404_path = kwargs.get('error_document404_path', None)
        self.default_index_document_path = kwargs.get('default_index_document_path', None)


class StorageError(msrest.serialization.Model):
    """StorageError.

    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message:
        :paramtype message: str
        """
        super(StorageError, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)


class StorageServiceProperties(msrest.serialization.Model):
    """Storage Service Properties.

    :ivar logging: Azure Analytics Logging settings.
    :vartype logging: ~azure.storage.blob.models.Logging
    :ivar hour_metrics: a summary of request statistics grouped by API in hour or minute aggregates
     for blobs.
    :vartype hour_metrics: ~azure.storage.blob.models.Metrics
    :ivar minute_metrics: a summary of request statistics grouped by API in hour or minute
     aggregates for blobs.
    :vartype minute_metrics: ~azure.storage.blob.models.Metrics
    :ivar cors: The set of CORS rules.
    :vartype cors: list[~azure.storage.blob.models.CorsRule]
    :ivar default_service_version: The default version to use for requests to the Blob service if
     an incoming request's version is not specified. Possible values include version 2008-10-27 and
     all more recent versions.
    :vartype default_service_version: str
    :ivar delete_retention_policy: the retention policy which determines how long the associated
     data should persist.
    :vartype delete_retention_policy: ~azure.storage.blob.models.RetentionPolicy
    :ivar static_website: The properties that enable an account to host a static website.
    :vartype static_website: ~azure.storage.blob.models.StaticWebsite
    """

    _attribute_map = {
        'logging': {'key': 'Logging', 'type': 'Logging'},
        'hour_metrics': {'key': 'HourMetrics', 'type': 'Metrics'},
        'minute_metrics': {'key': 'MinuteMetrics', 'type': 'Metrics'},
        'cors': {'key': 'Cors', 'type': '[CorsRule]', 'xml': {'wrapped': True}},
        'default_service_version': {'key': 'DefaultServiceVersion', 'type': 'str'},
        'delete_retention_policy': {'key': 'DeleteRetentionPolicy', 'type': 'RetentionPolicy'},
        'static_website': {'key': 'StaticWebsite', 'type': 'StaticWebsite'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword logging: Azure Analytics Logging settings.
        :paramtype logging: ~azure.storage.blob.models.Logging
        :keyword hour_metrics: a summary of request statistics grouped by API in hour or minute
         aggregates for blobs.
        :paramtype hour_metrics: ~azure.storage.blob.models.Metrics
        :keyword minute_metrics: a summary of request statistics grouped by API in hour or minute
         aggregates for blobs.
        :paramtype minute_metrics: ~azure.storage.blob.models.Metrics
        :keyword cors: The set of CORS rules.
        :paramtype cors: list[~azure.storage.blob.models.CorsRule]
        :keyword default_service_version: The default version to use for requests to the Blob service
         if an incoming request's version is not specified. Possible values include version 2008-10-27
         and all more recent versions.
        :paramtype default_service_version: str
        :keyword delete_retention_policy: the retention policy which determines how long the associated
         data should persist.
        :paramtype delete_retention_policy: ~azure.storage.blob.models.RetentionPolicy
        :keyword static_website: The properties that enable an account to host a static website.
        :paramtype static_website: ~azure.storage.blob.models.StaticWebsite
        """
        super(StorageServiceProperties, self).__init__(**kwargs)
        self.logging = kwargs.get('logging', None)
        self.hour_metrics = kwargs.get('hour_metrics', None)
        self.minute_metrics = kwargs.get('minute_metrics', None)
        self.cors = kwargs.get('cors', None)
        self.default_service_version = kwargs.get('default_service_version', None)
        self.delete_retention_policy = kwargs.get('delete_retention_policy', None)
        self.static_website = kwargs.get('static_website', None)


class StorageServiceStats(msrest.serialization.Model):
    """Stats for the storage service.

    :ivar geo_replication: Geo-Replication information for the Secondary Storage Service.
    :vartype geo_replication: ~azure.storage.blob.models.GeoReplication
    """

    _attribute_map = {
        'geo_replication': {'key': 'GeoReplication', 'type': 'GeoReplication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword geo_replication: Geo-Replication information for the Secondary Storage Service.
        :paramtype geo_replication: ~azure.storage.blob.models.GeoReplication
        """
        super(StorageServiceStats, self).__init__(**kwargs)
        self.geo_replication = kwargs.get('geo_replication', None)


class UserDelegationKey(msrest.serialization.Model):
    """A user delegation key.

    All required parameters must be populated in order to send to Azure.

    :ivar signed_oid: Required. The Azure Active Directory object ID in GUID format.
    :vartype signed_oid: str
    :ivar signed_tid: Required. The Azure Active Directory tenant ID in GUID format.
    :vartype signed_tid: str
    :ivar signed_start: Required. The date-time the key is active.
    :vartype signed_start: ~datetime.datetime
    :ivar signed_expiry: Required. The date-time the key expires.
    :vartype signed_expiry: ~datetime.datetime
    :ivar signed_service: Required. Abbreviation of the Azure Storage service that accepts the key.
    :vartype signed_service: str
    :ivar signed_version: Required. The service version that created the key.
    :vartype signed_version: str
    :ivar value: Required. The key as a base64 string.
    :vartype value: str
    """

    _validation = {
        'signed_oid': {'required': True},
        'signed_tid': {'required': True},
        'signed_start': {'required': True},
        'signed_expiry': {'required': True},
        'signed_service': {'required': True},
        'signed_version': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'signed_oid': {'key': 'SignedOid', 'type': 'str'},
        'signed_tid': {'key': 'SignedTid', 'type': 'str'},
        'signed_start': {'key': 'SignedStart', 'type': 'iso-8601'},
        'signed_expiry': {'key': 'SignedExpiry', 'type': 'iso-8601'},
        'signed_service': {'key': 'SignedService', 'type': 'str'},
        'signed_version': {'key': 'SignedVersion', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword signed_oid: Required. The Azure Active Directory object ID in GUID format.
        :paramtype signed_oid: str
        :keyword signed_tid: Required. The Azure Active Directory tenant ID in GUID format.
        :paramtype signed_tid: str
        :keyword signed_start: Required. The date-time the key is active.
        :paramtype signed_start: ~datetime.datetime
        :keyword signed_expiry: Required. The date-time the key expires.
        :paramtype signed_expiry: ~datetime.datetime
        :keyword signed_service: Required. Abbreviation of the Azure Storage service that accepts the
         key.
        :paramtype signed_service: str
        :keyword signed_version: Required. The service version that created the key.
        :paramtype signed_version: str
        :keyword value: Required. The key as a base64 string.
        :paramtype value: str
        """
        super(UserDelegationKey, self).__init__(**kwargs)
        self.signed_oid = kwargs['signed_oid']
        self.signed_tid = kwargs['signed_tid']
        self.signed_start = kwargs['signed_start']
        self.signed_expiry = kwargs['signed_expiry']
        self.signed_service = kwargs['signed_service']
        self.signed_version = kwargs['signed_version']
        self.value = kwargs['value']
