# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LabeledUtterance(Model):
    """A prediction and label pair of an example.

    :param id: ID of Labeled Utterance.
    :type id: int
    :param text: The utterance. E.g.: what's the weather like in seattle?
    :type text: str
    :param tokenized_text: The utterance tokenized.
    :type tokenized_text: list[str]
    :param intent_label: The intent matching the example.
    :type intent_label: str
    :param entity_labels: The entities matching the example.
    :type entity_labels:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityLabel]
    :param intent_predictions: List of suggested intents.
    :type intent_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.IntentPrediction]
    :param entity_predictions: List of suggested entities.
    :type entity_predictions:
     list[~azure.cognitiveservices.language.luis.authoring.models.EntityPrediction]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'text': {'key': 'text', 'type': 'str'},
        'tokenized_text': {'key': 'tokenizedText', 'type': '[str]'},
        'intent_label': {'key': 'intentLabel', 'type': 'str'},
        'entity_labels': {'key': 'entityLabels', 'type': '[EntityLabel]'},
        'intent_predictions': {'key': 'intentPredictions', 'type': '[IntentPrediction]'},
        'entity_predictions': {'key': 'entityPredictions', 'type': '[EntityPrediction]'},
    }

    def __init__(self, **kwargs):
        super(LabeledUtterance, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.text = kwargs.get('text', None)
        self.tokenized_text = kwargs.get('tokenized_text', None)
        self.intent_label = kwargs.get('intent_label', None)
        self.entity_labels = kwargs.get('entity_labels', None)
        self.intent_predictions = kwargs.get('intent_predictions', None)
        self.entity_predictions = kwargs.get('entity_predictions', None)
