#$Header: /var/local/cvsroot/4Suite/test/Server/Common/test_validationinfo.py,v 1.4 2004/11/15 18:29:58 lmorillas Exp $

from Ft.Server import FTSS_URI_SCHEME
from Ft.Server.Common import ValidationInfo, DocumentReference
from Ft.Server.Server import FtServerServerException, Error

from Server.Server.SCore import test_helper

def test_no_validation(tester):
    tester.startTest("No Validation")

    nv = ValidationInfo.NoValidation()
    tester.compare(1, nv.validate(None, None, FTSS_URI_SCHEME + ':///dummy'))
    tester.testDone()


def test_dtd_validation(tester):
    tester.startTest("DTD Validation")

    dv = ValidationInfo.DtdValidationInfo(None)
    tester.testException(dv.validate,
                         (None, None, FTSS_URI_SCHEME + ':///dummy.xml'),
                         NotImplementedError)
    tester.testDone()


def test_schematron_validation(tester):
    tester.startTest("Schematron Validation")

    repo = test_helper.GetRepo(tester)

    dr = DocumentReference.StringDocumentReference(SCHEMA1,
          FTSS_URI_SCHEME + ':///string-from-var-SCHEMA1')
    sv = ValidationInfo.SchematronValidationInfo(dr)
    tester.compare(1, sv.validate(repo, DOC1, FTSS_URI_SCHEME + ':///string-from-var-DOC1'))
    tester.compare(0, sv.validate(repo, DOC2, FTSS_URI_SCHEME + ':///string-from-var-DOC2'))
    repo.txRollback()
    tester.testDone()


def Test(tester):
    test_no_validation(tester)
    test_dtd_validation(tester)
    test_schematron_validation(tester)


DOC1="""<docelem v='foo'/>"""
DOC2="""<docelem w='foo'/>"""

SCHEMA1="""<schema xmlns='http://www.ascc.net/xml/schematron'>

  <pattern name='Root'>
    <rule context="/docelem">
      <assert test='@v'>
        VALIDATION ERROR: The root element must have a v attribute
      </assert>
    </rule>
  </pattern>

</schema>"""

