<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  home.xslt

Description:

    This stylesheet generates the login page.
    It can be applied to any XML source document.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:include href="menu-includes.xslt"/>

  <!-- this query string param will have been set to 1 if the previous login attempt failed -->
  <xsl:param name="invalid" select="0"/>

  <!-- this query string param will have been set to 1 if the session expired -->
  <xsl:param name="expired" select="0"/>

  <xsl:template match="/">
    <xsl:call-template name="menus">
      <xsl:with-param name="expired" select="$expired"/>
      <xsl:with-param name="pageTitle" select="'Buyer Base - Login'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="body">
    <table width="695" class="normal">
      <tr class="cellBlue">
        <td class="menucell" align="left"><div class="menu">Login</div></td>
      </tr>
      <tr>
        <td>
          <p class="blackTitle">Buyer Base is a demo of the 4Suite repository;<br/>It is a complete application written without traditional application code.</p>
          <p class="normal">The interface and business logic are all done via XSLT applied to XML documents from the repository. New documents are created and data in the RDF model is queried via extension functions &amp; elements.</p>
          <p class="normal">You are a Buyer, creating purchase orders on behalf of your customers.<br/>You will need to log in as a valid 4Suite repository user, or as 'guest' with any password.</p>
        </td>
      </tr>
      <tr>
        <td>
          <xsl:if test="$invalid">
            <p class="blackTitle"><font color="red">Invalid login!</font></p>
          </xsl:if>
          <form method="post" action="{$fres:uri-path}">
            <input type='hidden' name='post-login' value='/buyerbase/?xslt=index.xslt'/>
            <input type='hidden' name='invalid-login' value='/buyerbase/?xslt=home.xslt&amp;invalid=1'/>
            <input type='hidden' name='action-name' value='login'/>
            <p class="normal">Please enter your login information:</p>
            <p>
              <!-- separate spans are for Netscape 4 -->
              <span class="blackTitle">User Name:&nbsp; </span>
              <input type="text" name="user-name" size="20" class="textBox" tabindex="1"/>
              <br/>
              <span class="blackTitle">Password:&nbsp;&nbsp;&nbsp; </span>
              <input type="password" name="password" size="20" class="textBox" tabindex="2"/>
            </p>
            <input type="submit" value="Login" class="button" name="login" tabindex="3"/>
          </form>
        </td>
      </tr>
    </table>
  </xsl:template>
</xsl:stylesheet>
