import test_literal_expr
from Ft.Xml.XPath import ParsedExpr, NaN, Inf

test_literal_expr.setupStringLiterals()
StringLiterals = test_literal_expr.StringLiterals
test_literal_expr.setupNumberLiterals()
NumberLiterals = test_literal_expr.NumberLiterals


def RunTests(tester, tests):
    for klass, cases in tests:
        tester.startGroup(klass.__name__)
        for args, expected in cases:
            expr = klass(*args)
            # of course the test started already,
            # but we like the nice string repr
            tester.startTest(repr(expr))
            result = expr.evaluate(None)
            tester.compare(expected, result, 'Wrong result evaluating "%s".' % repr(expr))
            tester.testDone()
        tester.groupDone()


def Test(tester):

    tester.startGroup('Numeric Expressions with Number Literals')

    tester.startTest('Creating test environment')

    # IEEE 754 says:
    #
    #   +-Infinity * +-Infinity = +-Infinity
    #   +-Infinity * 0 = NaN
    #
    #   n div +-Infinity = 0
    #   +-nonzero div 0 = +-Infinity
    #   +-Infinity div +-Infinity = NaN
    #   +-0 div +-0 = NaN
    #
    #   Infinity + Infinity = Infinity
    #   Infinity - Infinity = NaN

    # operators:
    #    *  -> 0
    #   div -> 1
    #   mod -> 2
    multiply_tests = [#(operator, left expression, right expression), expected result)
                      ((0, NumberLiterals['N5'][0], NumberLiterals['2'][0]), -10.0),
                      ((0, NumberLiterals['N4'][0], NumberLiterals['N2'][0]), 8.0),
                      ((0, NumberLiterals['0'][0], NumberLiterals['2'][0]), 0.0),
                      ((0, NumberLiterals['Inf'][0], NumberLiterals['Inf'][0]), Inf),
                      ((0, NumberLiterals['NInf'][0], NumberLiterals['NInf'][0]), Inf),
                      ((0, NumberLiterals['Inf'][0], NumberLiterals['NInf'][0]), -Inf),
                      ((1, NumberLiterals['0'][0], NumberLiterals['2'][0]), 0.0),
                      ((1, NumberLiterals['N5'][0], NumberLiterals['2'][0]), -2.5),
                      ((1, NumberLiterals['N4'][0], NumberLiterals['N2'][0]), 2.0),
                      ((1, NumberLiterals['0'][0], NumberLiterals['0'][0]), NaN),
                      ((1, NumberLiterals['1'][0], NumberLiterals['0'][0]), Inf),
                      ((1, NumberLiterals['N1'][0], NumberLiterals['0'][0]), -Inf),
                      ((1, NumberLiterals['0'][0], NumberLiterals['Inf'][0]), 0),
                      ((1, NumberLiterals['1'][0], NumberLiterals['Inf'][0]), 0),
                      ((1, NumberLiterals['N1'][0], NumberLiterals['Inf'][0]), 0),
                      ((1, NumberLiterals['0'][0], NumberLiterals['NInf'][0]), 0),
                      ((1, NumberLiterals['1'][0], NumberLiterals['NInf'][0]), 0),
                      ((1, NumberLiterals['N1'][0], NumberLiterals['NInf'][0]), 0),
                      ((1, NumberLiterals['Inf'][0], NumberLiterals['Inf'][0]), NaN),
                      ((1, NumberLiterals['Inf'][0], NumberLiterals['NInf'][0]), NaN),
                      ((1, NumberLiterals['NInf'][0], NumberLiterals['NInf'][0]), NaN),
                      ((1, NumberLiterals['NInf'][0], NumberLiterals['Inf'][0]), NaN),
                      ((2, NumberLiterals['0'][0], NumberLiterals['2'][0]), 0.0),
                      ((2, NumberLiterals['5'][0], NumberLiterals['2'][0]), 1.0),
                      ((2, NumberLiterals['5'][0], NumberLiterals['N2'][0]), -1.0),
                      ((2, NumberLiterals['N5'][0], NumberLiterals['2'][0]), 1.0),
                      ((2, NumberLiterals['N5'][0], NumberLiterals['N2'][0]), -1.0),
                      ]

    # operators:
    #   + -> 1
    #   - -> -1
    addition_tests = [((1, NumberLiterals['5'][0], NumberLiterals['2'][0]), 7.0),
                      ((1, NumberLiterals['3'][0], NumberLiterals['N2'][0]), 1.0),
                      ((1, NumberLiterals['Inf'][0], NumberLiterals['Inf'][0]), Inf),
                      ((-1, NumberLiterals['5'][0], NumberLiterals['2'][0]), 3.0),
                      ((-1, NumberLiterals['3'][0], NumberLiterals['N2'][0]), 5.0),
                      ((-1, NumberLiterals['Inf'][0], NumberLiterals['Inf'][0]), NaN),
                      ]

    unary_tests = [((NumberLiterals['5'][0],), -5.0),
                   ((NumberLiterals['N2'][0],), 2.0),
                   ]

    tests = [(ParsedExpr.ParsedMultiplicativeExpr, multiply_tests),
             (ParsedExpr.ParsedAdditiveExpr, addition_tests),
             (ParsedExpr.ParsedUnaryExpr, unary_tests),
             ]
    tester.testDone()

    RunTests(tester, tests)

    tester.groupDone()

    # basically tests automatic coercion of strings to numbers
    tester.startGroup('Numeric Expressions with String Literals')

    tester.startTest('Creating test environment')

    multiply_tests = [#(operator, left expression, right expression), expected result)
                      ((0, StringLiterals['N5'][0], StringLiterals['2'][0]), -10.0),
                      ((0, StringLiterals['N4'][0], StringLiterals['N2'][0]), 8.0),
                      ((0, StringLiterals['0'][0], StringLiterals['2'][0]), 0.0),
                      ((0, StringLiterals['1'][0], StringLiterals['1'][0]), 1.0),
                      ((0, StringLiterals['Pi'][0], StringLiterals['1'][0]), 3.1415926535),
                      ((0, StringLiterals['Empty'][0], StringLiterals['1'][0]), NaN),
                      ((0, StringLiterals['Hi'][0], StringLiterals['1'][0]), NaN),
                      ((0, StringLiterals['NaN'][0], StringLiterals['1'][0]), NaN),
                      ((0, StringLiterals['Unicode'][0], StringLiterals['1'][0]), NaN),
                      ((1, StringLiterals['0'][0], StringLiterals['2'][0]), 0.0),
                      ((1, StringLiterals['1'][0], StringLiterals['1'][0]), 1.0),
                      ((1, StringLiterals['N5'][0], StringLiterals['2'][0]), -2.5),
                      ((1, StringLiterals['N4'][0], StringLiterals['N2'][0]), 2.0),
                      ((1, StringLiterals['0'][0], StringLiterals['0'][0]), NaN),
                      ((1, StringLiterals['1'][0], StringLiterals['0'][0]), Inf),
                      ((1, StringLiterals['N1'][0], StringLiterals['0'][0]), -Inf),
                      ((2, StringLiterals['0'][0], StringLiterals['2'][0]), 0.0),
                      ((2, StringLiterals['5'][0], StringLiterals['2'][0]), 1.0),
                      ((2, StringLiterals['5'][0], StringLiterals['N2'][0]), -1.0),
                      ((2, StringLiterals['N5'][0], StringLiterals['2'][0]), 1.0),
                      ((2, StringLiterals['N5'][0], StringLiterals['N2'][0]), -1.0),
                      ]

    addition_tests = [((1, StringLiterals['5'][0], StringLiterals['2'][0]), 7.0),
                      ((1, StringLiterals['3'][0], StringLiterals['N2'][0]), 1.0),
                      ((-1, StringLiterals['5'][0], StringLiterals['2'][0]), 3.0),
                      ((-1, StringLiterals['3'][0], StringLiterals['N2'][0]), 5.0),
                      ]

    unary_tests = [((StringLiterals['5'][0],), -5.0),
                   ((StringLiterals['N2'][0],), 2.0),
                   ]

    tests = [(ParsedExpr.ParsedMultiplicativeExpr, multiply_tests),
             (ParsedExpr.ParsedAdditiveExpr, addition_tests),
             (ParsedExpr.ParsedUnaryExpr, unary_tests),
             ]
    tester.testDone()

    RunTests(tester, tests)

    tester.groupDone()

    return
