from Ft.Xml import HAS_PYEXPAT
from Ft.Xml import InputSource
from Ft.Xml import cDomlette, FtMiniDom, Domlette

def test_get_all_ns(tester, module):
    tester.startGroup(module.__name__)
    
    src_1 = """
<foo:bar xmlns:foo='http://foo.com'><baz:bar xmlns:baz='http://baz.com'/>
</foo:bar>
"""
    isrc = InputSource.DefaultFactory.fromString(src_1, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Simple")
    node = doc.documentElement
    res = module.GetAllNs(node)
    tester.compare(2,len(res.keys()))
    tester.compare(1,res.has_key('xml'))
    tester.compare(1,res.has_key('foo'))
    tester.compare('http://foo.com',res['foo'])
    tester.compare('http://www.w3.org/XML/1998/namespace',res['xml'])
    tester.testDone()


    tester.startTest("Simple One Deep")
    node = doc.documentElement.firstChild
    res = module.GetAllNs(node)
    tester.compare(3,len(res.keys()))
    tester.compare(1,res.has_key('xml'))
    tester.compare(1,res.has_key('foo'))
    tester.compare(1,res.has_key('baz'))
    tester.compare('http://foo.com',res['foo'])
    tester.compare('http://baz.com',res['baz'])
    tester.compare('http://www.w3.org/XML/1998/namespace',res['xml'])
    tester.testDone()

    src_2 = """
<foo:bar xmlns='http://default.com'
         xmlns:foo='http://foo.com'
         xmlns:baz='http://baz.com'
/>"""
    isrc = InputSource.DefaultFactory.fromString(src_2, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Unused xmlns declaration")
    node = doc.documentElement
    res = module.GetAllNs(node)
    tester.compare(4,len(res.keys()))
    tester.compare(1,res.has_key('xml'))
    tester.compare(1,res.has_key('foo'))
    tester.compare(1,res.has_key('baz'))
    tester.compare(1,res.has_key(None))
    tester.compare('http://foo.com',res['foo'])
    tester.compare('http://baz.com',res['baz'])
    tester.compare('http://default.com',res[None])
    tester.compare('http://www.w3.org/XML/1998/namespace',res['xml'])
    tester.testDone()

    doc = module.implementation.createDocument(None,None,None)
    elem = doc.createElementNS("http://element.com","foo:root")
    elem.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:foo","http://attrDecl")

    tester.startTest("Different element and namespace decl")
    res = module.GetAllNs(elem)
    tester.compare(2,len(res.keys()))
    tester.compare(1,res.has_key('xml'))
    tester.compare(1,res.has_key('foo'))
    tester.compare('http://element.com',res['foo'])
    tester.compare('http://www.w3.org/XML/1998/namespace',res['xml'])
    tester.testDone()

    tester.groupDone()
    return

def test_seek_nss(tester, module):
    tester.startGroup(module.__name__)
    
    src_1 = """
<foo:bar xmlns:foo='http://foo.com'>
  <baz:bar xmlns:baz='http://baz.com'/>
</foo:bar>
"""
    isrc = InputSource.DefaultFactory.fromString(src_1, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Simple")
    node = doc.documentElement
    res = module.SeekNss(node)
    tester.compare(2,len(res.keys()))
    tester.compare(1,res.has_key('foo'))
    tester.compare('http://foo.com',res['foo'])
    tester.compare(1,res.has_key('baz'))
    tester.compare('http://baz.com',res['baz'])
    tester.testDone()

    src_1a = """
<foo:bar xmlns:foo='http://foo.com'>
  <foo:bar xmlns:foo='http://other-foo.com'/>
</foo:bar>
"""
    isrc = InputSource.DefaultFactory.fromString(src_1a, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Redefined prefix")
    node = doc.documentElement
    res = module.SeekNss(node)
    tester.compare(1,len(res.keys()))
    tester.compare(1,res.has_key('foo'))
    tester.compare('http://foo.com',res['foo'])
    tester.testDone()

    src_2 = """
<foo:bar xmlns='http://default.com'
         xmlns:foo='http://foo.com'
         xmlns:baz='http://baz.com'
/>"""
    isrc = InputSource.DefaultFactory.fromString(src_2, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Unused xmlns declaration")
    node = doc.documentElement
    res = module.SeekNss(node)
    tester.compare(3,len(res.keys()))
    tester.compare(1,res.has_key('foo'))
    tester.compare(1,res.has_key('baz'))
    tester.compare(1,res.has_key(None))
    tester.compare('http://foo.com',res['foo'])
    tester.compare('http://baz.com',res['baz'])
    tester.compare('http://default.com',res[None])
    tester.testDone()

    src_3 = """
<foo:bar xmlns:foo='http://foo.com'
         xmlns:baz='http://baz.com'>
  <bar xmlns='http://default.com'/>
  <bar xmlns='http://other-default.com'/>
</foo:bar>"""
    isrc = InputSource.DefaultFactory.fromString(src_3, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Default xmlns declaration")
    node = doc.documentElement
    res = module.SeekNss(node)
    tester.compare(3,len(res.keys()))
    tester.compare(1,res.has_key('foo'))
    tester.compare(1,res.has_key('baz'))
    tester.compare(1,res.has_key(None))
    tester.compare('http://foo.com',res['foo'])
    tester.compare('http://baz.com',res['baz'])
    tester.compare('http://default.com',res[None])
    tester.testDone()

    src_4 = """
<foo:bar xmlns:foo='http://foo.com'
         xmlns:baz='http://baz.com'>
  <bar xmlns='http://default.com'/>
  <bar xmlns='http://other-default.com'/>
</foo:bar>"""
    isrc = InputSource.DefaultFactory.fromString(src_4, "dummy")
    doc = module.nonvalParse(isrc)

    tester.startTest("Multiple default xmlns declarations")
    node = doc.documentElement
    res = module.SeekNss(node)
    tester.compare(3,len(res.keys()))
    tester.compare(1,res.has_key('foo'))
    tester.compare(1,res.has_key('baz'))
    tester.compare(1,res.has_key(None))
    tester.compare('http://foo.com',res['foo'])
    tester.compare('http://baz.com',res['baz'])
    tester.compare('http://default.com',res[None])
    tester.testDone()

    tester.startTest("Multiple redefined xmlns declarations")
    src_5 = """
<S:foo xmlns:S="http://example.com/1"> 
  <bar>test</bar> 
  <bar xmlns='http://example.com/2'>test2</bar> 
  <S:bar xmlns:S='http://example.com/2'>test2</S:bar> 
</S:foo>"""
    isrc = InputSource.DefaultFactory.fromString(src_5, "dummy")
    doc = module.nonvalParse(isrc)
    res = module.SeekNss(doc)
    tester.compare(1,len(res.keys()))
    tester.compare(1,res.has_key('S'))
    tester.compare('http://example.com/1', res['S'])
    tester.testDone()

    doc = module.implementation.createDocument(None,None,None)
    elem = doc.createElementNS("http://element.com","foo:root")
    elem.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:foo","http://attrDecl")

    tester.startTest("Different element and namespace decl")
    res = module.SeekNss(elem)
    tester.compare(1,len(res.keys()))
    tester.compare(1,res.has_key('foo'))
    tester.compare('http://element.com',res['foo'])
    tester.testDone()

    tester.groupDone()
    return

def Test(tester):
    # -- GetAllNs ------------------------------------------------------
    
    tester.startGroup("GetAllNs")

    # cDomlette
    test_get_all_ns(tester, cDomlette)

    # FtMiniDom (needs pyexpat available for parsing)
    if HAS_PYEXPAT:
        test_get_all_ns(tester, FtMiniDom)

    # Default Domlette
    test_get_all_ns(tester, Domlette)
    
    tester.groupDone()

    # -- SeekNss -------------------------------------------------------
    
    tester.startGroup("SeekNss")

    # cDomlette
    test_seek_nss(tester, cDomlette)

    # FtMiniDom (needs pyexpat available for parsing)
    if HAS_PYEXPAT:
        test_seek_nss(tester, FtMiniDom)

    # Default Domlette
    test_seek_nss(tester, Domlette)

    tester.groupDone()
    return
