
from Ft.Server.Common import ResourceTypes

TEST_DBNAME = 'test_db'

import test_helper

def test_init(tester, driverModule, props):

    tester.startTest("Init of %s" % driverModule.NAME)

    if driverModule.Exists(props) != -1:
        driverModule.Destroy(props)

    tester.compare(-1, driverModule.Exists(props))

    driverModule.Initialize(props)

    tester.compare(1, driverModule.Exists(props))

    tester.testDone()


def test_create(tester, driverModule, props):

    tester.startTest("Create with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.createFile('/foo', ResourceTypes.RESOURCE_CONTENT, "Foo")
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()

    tester.startTest("Access after create with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Create and rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.createFile('/foo2', ResourceTypes.RESOURCE_CONTENT, "Foo")
    tester.compare(1, driver.hasFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("Foo", driver.fetchFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(0, driver.hasFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Create with binary")
    src = "Foo%sBar%sBaz%sDo%sDah\n" % (chr(0), "'", "\\", chr(3))
    src = src * 700
    #print repr(src)
    driver = apply(driverModule.Begin, (), props)
    driver.createFile('/foob', ResourceTypes.RESOURCE_CONTENT, src)
    tester.compare(1, driver.hasFile('/foob', ResourceTypes.RESOURCE_CONTENT))
    #print repr(driver.fetchFile('/foob', ResourceTypes.RESOURCE_CONTENT))
    tester.compare(src, driver.fetchFile('/foob', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()


def test_access(tester, driverModule, props):

    tester.startTest("Access with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    #Call twice to check caching
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

def test_modify(tester, driverModule, props):

    tester.startTest("Modify with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.updateFile('/foo', ResourceTypes.RESOURCE_CONTENT, 'New Foo')
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()

    tester.startTest("Modify after commit with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()


    tester.startTest("Modify rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.updateFile('/foo', ResourceTypes.RESOURCE_CONTENT, 'New Foo2')
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo2", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Modify after rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()


    tester.startTest("Modify CC with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.createFile('/foo2', ResourceTypes.RESOURCE_CONTENT, 'Foo2')
    driver.updateFile('/foo2', ResourceTypes.RESOURCE_CONTENT, 'New Foo2')
    tester.compare(1, driver.hasFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo2", driver.fetchFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()

    tester.startTest("Modify CC after commit with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo2", driver.fetchFile('/foo2', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()


    tester.startTest("Modify CC rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.createFile('/foo3', ResourceTypes.RESOURCE_CONTENT, 'Foo3')
    driver.updateFile('/foo3', ResourceTypes.RESOURCE_CONTENT, 'New Foo3')
    tester.compare(1, driver.hasFile('/foo3', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo3", driver.fetchFile('/foo3', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Modify after rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(0, driver.hasFile('/foo3', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()



    tester.startTest("Modify RC with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT)
    driver.updateFile('/foo', ResourceTypes.RESOURCE_CONTENT, 'New Foo 100')
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo 100", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()

    tester.startTest("Modify RC after commit with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo 100", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()


    tester.startTest("Modify RC rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT)
    driver.updateFile('/foo', ResourceTypes.RESOURCE_CONTENT, 'New Foo 1000')
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo 1000", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Modify RC after rollback with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    tester.compare("New Foo 100", driver.fetchFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

def test_delete(tester, driverModule, props):

    tester.startTest("Delete with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.deleteFile('/foo', ResourceTypes.RESOURCE_CONTENT)
    tester.compare(0, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Delete didn't stick with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(1, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()

    tester.startTest("Delete with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    driver.deleteFile('/foo', ResourceTypes.RESOURCE_CONTENT)
    tester.compare(0, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.commit()
    tester.testDone()

    tester.startTest("Delete did stick with %s" % driverModule.NAME)
    driver = apply(driverModule.Begin, (), props)
    tester.compare(0, driver.hasFile('/foo', ResourceTypes.RESOURCE_CONTENT))
    driver.rollback()
    tester.testDone()



def test_concurrency(tester, driverModule, props):

    tester.startTest("Concurrency with %s" % driverModule.NAME)
    tester.warning("Not Tested")
    tester.testDone()

def test_mthreads(tester, driverModule, props):

    tester.startTest("Two threads doing read/write/etc to same object with %s" % driverModule.NAME)
    tester.warning("Not Tested")
    tester.testDone()


def Test(tester, driverModule, props):
    test_init(tester, driverModule, props)
    test_create(tester, driverModule, props)
    test_access(tester, driverModule, props)
    test_modify(tester, driverModule, props)
    test_delete(tester, driverModule, props)
    test_concurrency(tester, driverModule, props)
    test_mthreads(tester, driverModule, props)

