
from Ft.Lib.CommandLine import CommandLineTestUtil
import test_prime


FIRST_CONTAINER = '/' + test_prime.BASE_CONTAINER + '/con1'

def Init(repo):
    if repo.hasResource(FIRST_CONTAINER):
        repo.deleteResource(FIRST_CONTAINER)
    repo.createContainer(FIRST_CONTAINER,1)


def Test(tester):

    test_prime.InitRepo(tester,Init,['4ss','fetch','container'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    #No options, just get the system user container
    tr = CommandLineTestUtil.TestRun('Basic Fetch',
                                     baseConfig,
                                     [FIRST_CONTAINER],
                                     expectedOut = expected_1%FIRST_CONTAINER)

    #Fetch an unknown container
    uri = '/' + test_prime.BASE_CONTAINER + '/con3'
    tr2 = CommandLineTestUtil.TestRun('Error Fetch',
                                      baseConfig,
                                      [uri],
                                      expectedOut=expected_2%uri)

    #Fetch not a container
    uri = '/ftss/commands/4ss.fetch.container'
    tr3 = CommandLineTestUtil.TestRun('Error Fetch not container',
                                      baseConfig,
                                      [uri],
                                      expectedOut=expected_3%uri)


    t = CommandLineTestUtil.Test('4ss fetch container',[tr,tr2,tr3])

    return t.test(tester)


expected_1 = "Listing of %s\ntotal: 0\n\n"
expected_2 = "Path %s is unknown\n\n"
expected_3 = "The resource '%s' is not a container.\n"
