#!/usr/bin/env python
########################################################################
# $Header: /var/local/cvsroot/4Suite/setup.py,v 1.26 2004/01/26 07:40:15 jkloth Exp $
"""
The master installation specification

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

# Create a dummy __config__ module to pass some setup-only values
# to the Ft module
import sys, imp

module = sys.modules['Ft.__config__'] = imp.new_module('Ft.__config__')
module.NAME = '4Suite'
module.VERSION = '0.0'
# If we want localizations during setup, we need to set this to the
# directory containing that message catalog hierarchy.
module.LOCALEDIR = None


# Add the structures to the global namespace for exec-ing the package files.
from distutils.core import Extension
from Ft.Lib.DistExt import Structures

structs = {'Extension' : Extension}
for name in Structures.__all__:
    structs[name] = getattr(Structures, name)


# Search out available packages
import os, glob

package_info = {}
for pkgfile in glob.glob(os.path.join('packages', '*.pkg')):
    pkginfo = {}
    execfile(pkgfile, structs, pkginfo)

    name = pkginfo.get('name')
    if not name:
        print "Unnamed package %r, skipped" % pkgfile
    elif package_info.has_key(name):
        print "Duplicate package %r, ignoring %r" % (name, pkgfile)
    else:
        # Remove any pkg-private declarations
        for key in pkginfo.keys():
            if key.startswith('_'):
                del pkginfo[key]

        package_info[name] = pkginfo


# Perform requested setup action(s)
from distutils.core import setup
from Ft.Lib.DistExt import PackageManager, Localization

setup(distclass=PackageManager.PackageManager,
      # PackageManager specific
      package_info=package_info,
      package_root='Ft',

      name='4Suite',
      version='1.0b1',
      description='an open-source platform for XML and RDF processing',
      author='Fourthought, Inc.',
      author_email='4suite@4suite.org',
      url='http://4suite.org/',
      license='The current license is at http://4suite.org/COPYRIGHT',
      long_description=('4Suite is a Python-based toolkit for XML and RDF '
                        'application development. '
                        'At the core of 4Suite is a library of integrated '
                        'tools (including convenient command-line tools) '
                        'for XML processing, implementing open technologies '
                        'such as DOM, RDF, XSLT, XInclude, XPointer, XLink, '
                        'XPath, XUpdate, RELAX NG, and XML/SGML Catalogs. '
                        'Layered upon this is an XML '
                        'and RDF data repository and server. The server '
                        'supports multiple methods of data access, query, '
                        'indexing, transformation, rich linking, and rules '
                        'processing. It provides the data infrastructure of '
                        'a full database management system, including '
                        'transactions and concurrency support, access '
                        'control and a variety of management tools. For '
                        'purposes of integration with other tools, it '
                        'supports remote, cross-platform and cross-language '
                        'access through HTTP (including native SOAP and '
                        'WebDAV), RPC, FTP and CORBA. It offers APIs in '
                        'Python, HTTP, SOAP and XSLT.'),
      # undocumented but shows up in setup.py --help
      platforms=['posix', 'win32', 'cygwin'],
      # also undocumented
      keywords=['Python', 'XML', 'RDF', 'XSLT', 'XPath', 'DOM',
                'XInclude', 'XPointer', 'XLink', 'XUpdate',
                'RELAX', 'XML Catalogs',
                'HTTP', 'FTP', 'CORBA', 'SOAP', 'WebDAV',
                '4Suite', '4SS', 'PyXML',
                'server', 'repository', 'metadata',
                ],

      manifest_templates=['graft packages'],

      # Ignore ODS files
      validate_templates=['prune Ft/Ods',
                          'prune test/Ods',
                          'prune profile/Ods',
                          ],
      )
