'''
An introduction to 4RDF

If you want to use lower-level APIs, e.g. to create an empty model,
see schema.py
'''
'''
Note: if you get an exception such as

_pg.error: FATAL 1:  user "root" does not exist

Then you may have to change the lines

        from Ft.Rdf.Drivers import Postgres
        #Create the database
        connect = 'pygres_demo'
        Postgres.CreateDb(connect)
        Demo('Postgres', connect, 'pygres_demo')

to something like

        from Ft.Rdf.Drivers import Postgres
        #Create the database
        connect = 'postgres@localhost:5432:pygres_demo'
        Postgres.CreateDb(connect)
        Demo('Postgres', connect, 'pygres_demo')


'''

import sys
from Ft.Rdf.RdfsHandler import RdfsConstraintViolation
from Ft.Xml.Domlette import NonvalidatingReader, PrettyPrint
from Ft.Lib import Uri
from Ft.Rdf import Util


def Demo(model, db):
    #Print triples serialized from the document
    print model.complete(None, None, None)
    
    #Change the language to french
    from Ft.Rdf import Statement
    #First check the status
    print model.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)
    
    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'en')
    model.remove(ns)
    #Check again
    print model.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    ns = Statement.Statement('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', 'fr')
    model.add(ns)
    #Check again
    print model.complete('http://www.dlib.org', 'http://purl.org/metadata/dublin_core#Language', None)

    #Now write it all back out in XML
    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    outdoc = serializer.serialize(model)
    PrettyPrint(outdoc)

    db.commit()
    return


def MemorySetup():
    #With the memory driver, the model is not persistent
    from Ft.Rdf.Drivers import Memory
    #Note that the name is not significant for the memory driver
    model, db = Util.DeserializeFromUri('w3c1.rdf', driver=Memory,
                                        dbName='memory_demo', create=1)
    return model, db


#Dbm driver for simple persistence
def DbmSetup():
    from Ft.Rdf.Drivers import Dbm
    #The dbm database name is the name of the DB or DBM file
    #if not Dbm.ExistsDb('mydemo.dbm'):
    #    db = Dbm.CreateDb('mydemo.dbm')
    #else:
    #    db = Dbm.GetDb('mydemo.dbm')
    #db.begin()
    model, db = Util.DeserializeFromUri('w3c1.rdf', driver=Dbm,
                                        dbName='dbm_demo', create=1)
    return model, db


def SqlSetup(driver, connect, modelName):
    try:
        driver = "Ft.Rdf.Drivers." + driver
        driver_mod = __import__(driver, {}, {}, ["*"])
    except:
        raise SystemExit("Unknown driver '%s'" % driver)

    model, db = Util.DeserializeFromUri('w3c1.rdf', driver=driver_mod,
                                        dbName=connect, create=1)
    #Set up to use the Postgres database of the given instance name
    #db = driver_mod.GetDb(connect)
    return model, db


if __name__ == '__main__':
    print "Run the demo using the memory driver"
    model, db = MemorySetup()
    Demo(model, db)
    print "Demo completed\n"
    model, db = DbmSetup()
    Demo(model, db)
    print "Demo completed\n"
##    try:
##        print "Attempt to run the demo using the PsycoPG driver"
##        from Ft.Rdf.Drivers import Psyco
##        #Create the database
##        Psyco.CreateDb('dbname=ftrdf_demo', 'demo')
##        Demo('Psyco', 'dbname=ftrdf_demo', 'demo')
##        print "Demo completed\n"
##    except:
##        print "Psyco demo could not be completed.\n"
##    sys.exit(0)
    try:
        print "Attempt to run the demo using the Postgres driver"
        from Ft.Rdf.Drivers import Postgres
        #Create the database
        connect = 'pygres_demo'
        #connect = 'rdf:postgres@localhost:5432:pygres_demo'
        #Postgres.CreateDb(connect)
        model, db = SqlSetup('Postgres', connect, 'pygres_demo')
        Demo(model, db)
        print "Demo completed\n"
    except Exception, e:
        print "Postgres demo could not be completed.  Reason:\n"
        print e
    print "Demo completed\n"

