/***********************************************************************
 * $Header: /var/local/cvsroot/4Suite/Ft/Xml/src/splitqname.c,v 1.4 2004/02/01 02:47:46 jkloth Exp $
 ***********************************************************************/

static char module_doc[] = "\
Optimized implementations of various utility functions.\n\
\n\
Copyright 2004 Fourthought, Inc. (USA).\n\
Detailed license and copyright information: http://4suite.org/COPYRIGHT\n\
Project home, documentation, distributions: http://4suite.org/\n\
";

#define SPLITQNAME_STANDALONE

#include "splitqname.h"

static char SplitQName_doc[] = \
"SplitQName(qualifiedName) -> (prefix, localName)\n\
\n\
where 'qualifiedName' is a QName according to XML Namespaces 1.0\n\
<http://www.w3.org/TR/REC-xml-names>.\n\
returns the name parts according to the spec.";

PyObject *PySplitQName(PyObject *self, PyObject *args)
{
  PyObject *qualifiedName, *localName, *prefix, *result;

  if (!PyArg_ParseTuple(args, "O:SplitQName", &qualifiedName))
    return NULL;

  qualifiedName = PyUnicode_FromObject(qualifiedName);
  if (!qualifiedName) return NULL;

  if (Standalone_SplitQName(qualifiedName, &prefix, &localName) == 0) {
    Py_DECREF(qualifiedName);
    return NULL;
  }

  result = PyTuple_New(2);
  if (result == NULL) {
    Py_DECREF(prefix);
    Py_DECREF(localName);
    return NULL;
  }

  /* steals references */
  PyTuple_SET_ITEM(result, 0, prefix);
  PyTuple_SET_ITEM(result, 1, localName);
  return result;
}


/*The external interface definitions */
static PyMethodDef module_methods[] = {
  { "SplitQName", PySplitQName, METH_VARARGS, SplitQName_doc },
  { NULL, NULL }
};

DL_EXPORT(void) initSplitQNamec(void)
{
  PyObject *module;

  module = Py_InitModule3("SplitQNamec", module_methods, module_doc);
  if (module == NULL) return;
 
  return;
}



