#ifndef DOMLETTE_UTIL_H
#define DOMLETTE_UTIL_H

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"

  PyObject *DOMString_FromObject(PyObject *obj);
  PyObject *DOMString_FromObjectInplace(PyObject *obj);
  PyObject *DOMString_ConvertArgument(PyObject *arg, char *name, int null_ok);

  /* testing */
  void AddInternCtr(PyObject *obj, PyObject *dict);
  int TestRefCount(PyObject *tester, PyObject *obj, int expected, const char *name);

  /* nodeName manipulation */
  int SplitQName(PyObject *qualifiedName, PyObject **prefix, 
                 PyObject **localName);

/* See http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/67112 */
#if defined(DEBUG_PARSER)
#define Py_DEBUG
extern void _Py_CountReferences(FILE*);
#define CURIOUS(x) { fprintf(stderr, __FILE__ ":%d ", __LINE__); x; }
#else
#define CURIOUS(x)
#endif
#define NEWLINE()       CURIOUS(fprintf(stderr, "\n"))
#define DESCRIBE(x)     CURIOUS(fprintf(stderr, "  " #x "=%d\n", x))
#define DESCRIBE_HEX(x) CURIOUS(fprintf(stderr, "  " #x "=%08x\n", x))
#define COUNTREFS()     CURIOUS(_Py_CountReferences(stderr))

#define PRINT_OBJECT(label, obj)               \
  fputs((label), stderr);                      \
  PyObject_Print((obj), stderr, Py_PRINT_RAW); \
  fputs("\n", stderr);

#ifdef __cplusplus
}
#endif

#endif /* DOMLETTE_UTIL_H */
