#ifndef __DOM__PROCESSING_INSTRUCTION__
#define __DOM__PROCESSING_INSTRUCTION__

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "node.h"

  typedef struct {
    PyNode_HEAD
    PyObject *nodeName;
    PyObject *nodeValue;
  } PyProcessingInstructionObject;

  extern PyTypeObject PyDomletteProcessingInstruction_Type;

#define PyProcessingInstruction_Check(op) ((op)->ob_type == &PyDomletteProcessingInstruction_Type)

#define PyProcessingInstruction_TARGET(op) \
(((PyProcessingInstructionObject *)(op))->nodeName)
#define PyProcessingInstruction_DATA(op) \
(((PyProcessingInstructionObject *)(op))->nodeValue)

  PyProcessingInstructionObject *ProcessingInstruction_CloneNode(
    PyObject *node, int deep, PyNodeObject *newOwnerDocument);

  int DomletteProcessingInstruction_Init(void);
  void DomletteProcessingInstruction_Fini(void);

  int pi_test_ref_counts(PyObject *tester,PyProcessingInstructionObject *node,long *childCtr,PyObject *internDict,int base);

  /*PI Methods */

#ifdef __cplusplus
}
#endif

#endif /* __DOM__PROCESSING_INSTRUCTION__ */
