#ifndef __DOM__NODE__
#define __DOM__NODE__

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "nodetype.h"

  /*Place holders for common thingies*/

  extern long g_nodeCount;


  /* PyNode_HEAD defines the initial segment of every Domlette node. */
#define PyNode_HEAD \
    PyObject_HEAD \
    PyObject *parentNode; \
    PyObject *ownerDocument; \
    unsigned long docIndex;

  /* Nothing is actually declared to be a PyNodeObject, but every pointer to
   * a Domlette object can be cast to a PyNodeObject*.  This is inheritance
   * built by hand.
   */
  typedef struct {
    PyNode_HEAD
  } PyNodeObject;

#define PyNode_PARENT_NODE(op) (((PyNodeObject *)(op))->parentNode)
#define PyNode_OWNER_DOCUMENT(op) (((PyNodeObject *)(op))->ownerDocument)
#define PyNode_INDEX(op) (((PyNodeObject *)(op))->docIndex)
  /* Node Creatation */
  PyNodeObject *_Node_New(PyTypeObject *type, PyObject *ownerDocument);
#define Node_New(type, typeobj, ownerdoc) \
  ((type *) _Node_New((typeobj), (PyObject *)(ownerdoc)))

  void _Node_Del(PyNodeObject *node);
#define Node_Del(obj) _Node_Del((PyNodeObject *)(obj))
  /* DOM Node Methods */
       
  PyNodeObject *Node_RemoveChild(PyNodeObject *self, PyNodeObject *child);
  PyNodeObject *Node_AppendChild(PyNodeObject *self, PyNodeObject *child);
  PyNodeObject *Node_InsertBefore(PyNodeObject *self, PyNodeObject *newChild,
				  PyNodeObject *refChild);

  PyNodeObject *Node_CloneNode(PyObject *node, int deep,
			       PyNodeObject *newOwnerDocument);

  int node_clear(PyNodeObject *node);
  int node_traverse(PyNodeObject *node, visitproc visit, void *arg);

  PyObject *node_getattr(PyNodeObject *self, char *name,struct PyMethodDef methods[]);
  int node_setattr(PyNodeObject *self, char *name, PyObject *v);

  int node_test_ref_counts(PyObject *tester,PyNodeObject *node,long *childCtr,PyObject *internDict,int base);


  /*Functions exposed to python*/
  PyObject *PyNode_normalize(PyObject * self, PyObject * args);
  PyObject *PyNode_hasChildNodes(PyObject * self, PyObject * args);
  PyObject *PyNode_removeChild(PyObject *self,PyObject *args);
  PyObject *PyNode_appendChild(PyObject *self,PyObject *args);
  PyObject *PyNode_insertBefore(PyObject *self,PyObject *args);
  PyObject *PyNode_replaceChild(PyObject *self,PyObject *args);
  PyObject *PyNode_cloneNode(PyObject *self,PyObject *args);
  PyObject *PyNode_isSameNode(PyObject *self, PyObject *args);
  PyObject *PyNode_xpath(PyObject *self, PyObject *args, PyObject *kw);


#define NODE_METHODS \
 { "normalize", (PyCFunction)PyNode_normalize, METH_VARARGS, \
   "Combine all neighboring text child nodes" }, \
 { "hasChildNodes", (PyCFunction)PyNode_hasChildNodes, METH_VARARGS, \
   "Return True if the node has children" }, \
 { "removeChild", (PyCFunction)PyNode_removeChild, METH_VARARGS, \
   "Remove a node from a child list" }, \
 { "appendChild", (PyCFunction)PyNode_appendChild, METH_VARARGS, \
   "Add a new child to the child list" }, \
 { "insertBefore", (PyCFunction)PyNode_insertBefore, METH_VARARGS, \
   "insert a new child to the child list" }, \
 { "replaceChild", (PyCFunction)PyNode_replaceChild,  METH_VARARGS, \
   "replace a child in the child list" }, \
 { "cloneNode", (PyCFunction)PyNode_cloneNode,  METH_VARARGS, \
   "Make a copy of a node from this document" }, \
 { "isSameNode", (PyCFunction)PyNode_isSameNode,  METH_VARARGS, \
     "true if this node instance is the same as another" }, \
 { "xpath", (PyCFunction)PyNode_xpath,  METH_VARARGS|METH_KEYWORDS, \
   "evaluate an XPath expression using this node as context" }

#ifdef __cplusplus
}
#endif

#endif /* __DOM__NODE__ */
