#ifndef DOMLETTE_EXCEPTIONS_H
#define DOMLETTE_EXCEPTIONS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"

  int DomletteExceptions_Init(void);
  void DomletteExceptions_Fini(void);

  PyObject *ReaderException_XmlParseError(PyObject *uri, int line, int column, 
                                          const char *description);

  PyObject *XIncludeException_InvalidParseAttr(PyObject *value);
  PyObject *XIncludeException_MissingHref(void);
       
  PyObject *DOMException_HierarchyRequestErr(const char *string);
  PyObject *DOMException_NotFoundErr(const char *string);
  PyObject *DOMException_NotSupportedErr(const char *string);
  PyObject *DOMException_InvalidStateErr(const char *string);
  PyObject *DOMException_NamespaceErr(const char *string);
  PyObject *DOMException_SyntaxErr(const char *string);

#define DOMString_NullCheck(ds)                                        \
if (PyUnicode_Check(ds) && !PyUnicode_GET_SIZE(ds)) {                  \
  DOMException_NamespaceErr("Use None instead of '' for null string"); \
  return NULL;                                                         \
} 

#ifdef __cplusplus
}
#endif

#endif /* DOMLETTE_EXCEPTIONS_H */
