#ifndef DOMLETTE_H
#define DOMLETTE_H

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32) || defined(__WIN32__)
#  define strcasecmp stricmp
#endif

#include "Python.h"
#include "compat.h"
#include "debug.h"
#include "util.h"

#include "exceptions.h"
#include "node.h"
#include "document.h"
#include "element.h"
#include "attr.h"
#include "documentfragment.h"
#include "domimplementation.h"
#include "text.h"
#include "processinginstruction.h"

/* namespace constants */
extern PyObject *g_xmlNamespace;
extern PyObject *g_xmlnsNamespace;
extern PyObject *g_xincludeNamespace;

  typedef struct {
    PyTypeObject *DOMImplementation_Type;
    PyTypeObject *Document_Type;
    PyTypeObject *Element_Type;
    PyTypeObject *Attr_Type;
    PyTypeObject *Text_Type;
    PyTypeObject *Comment_Type;
    PyTypeObject *ProcessingInstruction_Type;
    PyTypeObject *DocumentFragment_Type;
  } DomletteModule_APIObject;

#define PyNode_Check(op) (PyDocument_Check(op) || PyElement_Check(op) || PyText_Check(op) || PyProcessingInstruction_Check(op) || PyComment_Check(op) || PyAttr_Check(op) || PyDocumentFragment_Check(op))

#define PyNode_Children_Check(op) (PyDocument_Check(op) || PyElement_Check(op) || PyDocumentFragment_Check(op))

#define PyNode_Childless_Check(op) (PyText_Check(op) || PyProcessingInstruction_Check(op) || PyComment_Check(op))

#define PyDomlette_Check(node) if (!PyNode_Check(node)) { \
  PyErr_SetString(g_wrongDocumentErr, \
		  "Node created from unsupported document implementation"); \
  return NULL; \
}

PyObject *PyTestTree(PyObject * self, PyObject *args);


#ifdef __cplusplus
}
#endif
#endif /* !DOMLETTEOBJECT_H */

