#ifndef __DOM__DOCUMENT__
#define __DOM__DOCUMENT__

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"
#include "node.h"
#include "element.h"
#include "text.h"
#include "processinginstruction.h"
#include "comment.h"
#include "attr.h"
#include "documentfragment.h"

  typedef struct {
    PyNode_HEAD
    PyObject *childNodes;
    PyObject *internedUnicode;
    PyObject *documentUri;
    PyObject *publicId;
    PyObject *systemId;
    unsigned long nextIndex;
    PyObject *unparsedEntities;
  } PyDocumentObject;

  extern PyTypeObject PyDomletteDocument_Type;

#define PyDocument_Check(op) ((op)->ob_type == &PyDomletteDocument_Type)
#define PyDocument_CHILDNODES(op) (((PyDocumentObject *)(op))->childNodes)
#define PyDocument_BASE_URI(op) (((PyDocumentObject *)(op))->documentUri)
#define PyDocument_PUBLIC_ID(op) (((PyDocumentObject *)(op))->publicId)
#define PyDocument_SYSTEM_ID(op) (((PyDocumentObject *)(op))->systemId)
#define PyDocument_INDEX(op) (((PyDocumentObject *)(op))->nextIndex)

  int DomletteDocument_Init(void);
  void DomletteDocument_Fini(void);

  PyDocumentObject *Document_New(unsigned long *docIx, PyObject *documentUri);

  PyElementObject *Document_CreateElementNS(PyDocumentObject *self,
					    PyObject *namespaceURI,
                                            PyObject *qualifiedName,
					    PyObject *prefix,
					    PyObject *localName,
					    unsigned long *docIx);


  PyAttrObject *Document_CreateAttributeNS(PyDocumentObject *self,
					   PyObject *namespaceURI,
                                           PyObject *qualifiedName,
					   PyObject *prefix,
					   PyObject *localName,
                                           PyObject *value);

  PyTextObject *Document_CreateTextNode(PyDocumentObject *ownerDoc,
					PyObject *data,
					unsigned long *docIdx);

  PyProcessingInstructionObject *
  Document_CreateProcessingInstruction(PyDocumentObject *self,
				       PyObject *target, PyObject *data,
				       unsigned long *docIx);

  PyCommentObject *Document_CreateComment(PyDocumentObject *self,
                                          PyObject *data,
                                          unsigned long *docIx);

  PyDocumentFragmentObject *
  Document_CreateDocumentFragment(PyDocumentObject *ownerDoc);

  int document_test_ref_counts(PyObject *tester, PyDocumentObject *doc,
			       int base);

#ifdef __cplusplus
}
#endif


#endif
