#include "domlette.h"

/*Internal interfaces*/
int characterdata_setattr(PyCharacterDataObject *self, char *name, PyObject *v)
{
  /* Set attribute 'name' to value 'v'. v==NULL means delete */
  if (v == NULL) {
    PyErr_Format(PyExc_AttributeError, 
                 "Cannot delete attribute '%.400s' on '%.50s' object",
                 name, self->ob_type->tp_name);
    return -1;
  }

  if (!strcmp(name, "data") || !strcmp(name, "nodeValue")) {
    PyObject *nodeValue = DOMString_ConvertArgument(v, name, 0);
    if (nodeValue == NULL) return -1;

    Py_DECREF(self->nodeValue);
    self->nodeValue = nodeValue;
  } else {
    PyErr_Format(PyExc_AttributeError,
                 "Cannot set attribute '%.400s' on '%.50s' object", 
                 name, self->ob_type->tp_name);
    return -1;
  }
  return 0;
}

PyObject *CharacterData_SubstringData(PyObject *node, int index, int count)
{
  PyCharacterDataObject *self = (PyCharacterDataObject *)node;
  PyObject *newValue;

  newValue = PyUnicode_FromUnicode(NULL, count);
  if (!newValue) return NULL;

  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue),
                  PyUnicode_AS_UNICODE(self->nodeValue) + index,
                  count);
  return newValue;
}

int CharacterData_AppendData(PyObject *node, PyObject *arg)
{
  PyCharacterDataObject *self = (PyCharacterDataObject *)node;
  PyObject *oldValue = self->nodeValue;
  PyObject *newValue;

  newValue = PyUnicode_FromUnicode(NULL,
                                   PyUnicode_GET_SIZE(oldValue) + \
                                   PyUnicode_GET_SIZE(arg));
  if (!newValue) return -1;
  
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue),
                  PyUnicode_AS_UNICODE(oldValue),
                  PyUnicode_GET_SIZE(oldValue));
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue) + PyUnicode_GET_SIZE(oldValue),
                  PyUnicode_AS_UNICODE(arg),
                  PyUnicode_GET_SIZE(arg));

  Py_DECREF(oldValue);
  self->nodeValue = newValue;
  return 0;
}

int CharacterData_InsertData(PyObject *node, int offset, PyObject *arg)
{
  PyCharacterDataObject *self = (PyCharacterDataObject *)node;
  PyObject *oldValue = self->nodeValue;
  PyObject *newValue;

  newValue = PyUnicode_FromUnicode(NULL, 
                                   PyUnicode_GET_SIZE(oldValue) + \
                                   PyUnicode_GET_SIZE(arg));
  if (!newValue) return -1;

  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue), 
                  PyUnicode_AS_UNICODE(oldValue),
                  offset);
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue) + offset, 
                  PyUnicode_AS_UNICODE(arg),
                  PyUnicode_GET_SIZE(arg));
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue) + offset + PyUnicode_GET_SIZE(arg), 
                  PyUnicode_AS_UNICODE(oldValue) + offset,
                  PyUnicode_GET_SIZE(oldValue) - offset);

  Py_DECREF(oldValue);
  self->nodeValue = newValue;
  return 0;
}

int CharacterData_DeleteData(PyObject *node, int offset, int count)
{
  PyCharacterDataObject *self = (PyCharacterDataObject *)node;
  PyObject *oldValue = self->nodeValue;
  PyObject *newValue;

  newValue = PyUnicode_FromUnicode(NULL, PyUnicode_GET_SIZE(oldValue) - count);
  if (!newValue) return -1;
  
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue),
                  PyUnicode_AS_UNICODE(oldValue),
                  offset);
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue) + offset,
                  PyUnicode_AS_UNICODE(oldValue) + offset + count,
                  PyUnicode_GET_SIZE(oldValue) - offset - count);

  Py_DECREF(oldValue);
  self->nodeValue = newValue;
  return 0;
}

int CharacterData_ReplaceData(PyObject *node, int offset, int count, PyObject *arg)
{
  PyCharacterDataObject *self = (PyCharacterDataObject *)node;
  PyObject *oldValue = self->nodeValue;
  PyObject *newValue;

  newValue = PyUnicode_FromUnicode(NULL,
                                   PyUnicode_GET_SIZE(oldValue) - count + \
                                   PyUnicode_GET_SIZE(arg));
  if (!newValue) return -1;

  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue), 
                  PyUnicode_AS_UNICODE(oldValue),
                  offset);
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue) + offset, 
                  PyUnicode_AS_UNICODE(arg),
                  PyUnicode_GET_SIZE(arg));
  Py_UNICODE_COPY(PyUnicode_AS_UNICODE(newValue) + offset + PyUnicode_GET_SIZE(arg),
                  PyUnicode_AS_UNICODE(oldValue) + offset + count,
                  PyUnicode_GET_SIZE(oldValue) - offset - count);

  Py_DECREF(oldValue);
  self->nodeValue = newValue;
  return 0;
}

/*** Python Interfaces **************************************************/

PyObject *PyCharacterData_substringData(PyObject *self, PyObject *args)
{
  int offset, count;

  if (!PyArg_ParseTuple(args, "ii:substringData", &offset, &count))
    return NULL;

  return CharacterData_SubstringData(self, offset, count);
}

PyObject *PyCharacterData_appendData(PyObject *self, PyObject *args)
{
  PyObject *data;

  if (!PyArg_ParseTuple(args, "O:appendData", &data))
    return NULL;

  if ((data = DOMString_ConvertArgument(data, "data", 0)) == NULL)
    return NULL;

  if (CharacterData_AppendData(self, data) == -1) {
    Py_DECREF(data);
    return NULL;
  }
  Py_DECREF(data);

  Py_INCREF(Py_None);
  return Py_None;
}

PyObject *PyCharacterData_insertData(PyObject *self, PyObject *args)
{
  int offset;
  PyObject *data;

  if (!PyArg_ParseTuple(args, "iO:insertData", &offset, &data))
    return NULL;

  if ((data = DOMString_ConvertArgument(data, "data", 0)) == NULL)
    return NULL;

  if (CharacterData_InsertData(self, offset, data) == -1) {
    Py_DECREF(data);
    return NULL;
  }

  Py_DECREF(data);
  Py_INCREF(Py_None);
  return Py_None;
}

PyObject *PyCharacterData_deleteData(PyObject *self, PyObject *args)
{
  int offset, count;

  if (!PyArg_ParseTuple(args, "ii:deleteData", &offset, &count))
    return NULL;

  if (CharacterData_DeleteData(self, offset, count) == -1)
    return NULL;

  Py_INCREF(Py_None);
  return Py_None;
}

PyObject *PyCharacterData_replaceData(PyObject *self, PyObject *args)
{
  int offset, count;
  PyObject *data;

  if (!PyArg_ParseTuple(args, "iiO:replaceData", &offset, &count, &data))
    return NULL;

  if ((data = DOMString_ConvertArgument(data, "data", 0)) == NULL)
    return NULL;

  if (CharacterData_DeleteData(self, offset, count) == -1) {
    Py_DECREF(data);
    return NULL;
  }
  
  Py_DECREF(data);
  Py_INCREF(Py_None);
  return Py_None;
}
