########################################################################
#
# File Name:   ParsedRelativeLocationPath.py
#
# Docs:        http://docs.4suite.org/XPATH/ParsedRelativeLocationPath.py.html
#
"""
A Parsed Token that represents a relative location path in the parsed result tree.
WWW: http://4suite.org/XPATH        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

class ParsedRelativeLocationPath:
    def __init__(self, left, right):
        self._left = left
        self._right = right
        return

    def evaluate(self, context):
        nodeset = self._left.select(context)

        state = context.copy()

        result = []
        size = len(nodeset)
        for pos in range(size):
            context.node, context.position, context.size = \
                          nodeset[pos], pos + 1, size
            result.extend(self._right.select(context))

        context.set(state)
        return result
    select = evaluate

    def pprint(self, indent=''):
        print indent + str(self)
        self._left.pprint(indent + '  ')
        self._right.pprint(indent + '  ')

    def __str__(self):
        return '<RelativeLocationPath at %x: %s>' % (
            id(self),
            repr(self),
            )

    def __repr__(self):
        return repr(self._left) + '/' + repr(self._right)
