########################################################################
#
# File Name:   ParsedAbbreviatedAbsoluteLocationPath.py
#
# Docs:        http://docs.4suite.org/XPATH/ParsedAbbreviatedAbsoluteLocationPath.py.html
#
"""
A parsed token for an abreviated absolute location path.
WWW: http://4suite.org/XPATH        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from xml.dom import Node
from Ft.Xml.XPath import Util

class ParsedAbbreviatedAbsoluteLocationPath:
    def __init__(self, rel):
        self._rel = rel
        return

    def _descendants(self, context, nodeset):
        for child in context.node.childNodes:
            context.node = child
            results = self._rel.select(context)
            # Ensure no duplicates
            nodeset.extend(filter(lambda n, s=nodeset: n not in s, results))
            if child.nodeType == Node.ELEMENT_NODE:
                self._descendants(context, nodeset)
        return

    def evaluate(self, context):
        state = context.copy()

        # Start at the document node
        if context.node.ownerDocument:
            context.node = context.node.ownerDocument

        nodeset = self._rel.select(context)
        self._descendants(context, nodeset)

        context.set(state)
        return Util.SortDocOrder(context, nodeset)
    select = evaluate

    def pprint(self, indent=''):
        print indent + str(self)
        self._rel.pprint(indent + '  ')

    def __str__(self):
        return '<AbbreviatedAbsoluteLocationPath at %x: %s>' % (
            id(self),
            repr(self)
            )

    def __repr__(self):
        return '//%r' % self._rel

