########################################################################
#
# File Name:            XLinkElements.py
#
# Documentation:        http://docs.4suite.org/4XSLT/XLinkElements.py.html
#
"""
4XLink Elements
WWW: http://4suite.org/4XLink        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Xml.XLink import XLINK_NAMESPACE
from xml.dom import Node
from Ft.Xml import Domlette

def Create(node, baseUri):
    elemType = node.getAttributeNS(XLINK_NAMESPACE, 'type')
    return TypeMap.get(elemType, Literal)(node, baseUri)

class Literal:
    type = None

    def __init__(self, node, iSrc):
        self.resource = node
        self.input_source = iSrc

    def process(self):
        return

class Simple(Literal):
    type = "simple"

    def __init__(self, node, iSrc):
        Literal.__init__(self, node, iSrc)
        self.href = node.getAttributeNS(XLINK_NAMESPACE, 'href')
        self.role = node.getAttributeNS(XLINK_NAMESPACE, 'role')
        self.arcrole = node.getAttributeNS(XLINK_NAMESPACE, 'arcrole')
        self.title = node.getAttributeNS(XLINK_NAMESPACE, 'title')
        self.show = node.getAttributeNS(XLINK_NAMESPACE, 'show')
        self.actuate = node.getAttributeNS(XLINK_NAMESPACE, 'actuate')
        self.attributes = filter(lambda x: x.namespaceURI != XLINK_NAMESPACE,
                                 node.attributes.values())

    def process(self):
        resource = self.resource
        if self.actuate == "onLoad":
            doc = resource.rootNode
            if self.show == 'replace':
                newSrc = self.input_source.resolve(self.href,'','XLink')
                newDoc = Domlette.NonvalidatingReader.parse(newSrc)
                for node in self.attributes:
                    newDoc.documentElement.setAttributeNS(node.namespaceURI,
                                                          node.nodeName,
                                                          node.value)
                for child in resource.childNodes[:]:
                    nChild = doc.importNode(child)
                    newDoc.documentElement.appendChild(nChild)

                parent = resource.parentNode or doc
                for child in newDoc.documentElement.childNodes[:]:
                    newDoc.documentElement.removeChild(child)
                    child = doc.importNode(child)
                    parent.insertBefore(child,resource)
                parent.removeChild(resource)

            elif self.show == 'embed':
                newSrc = self.input_source.resolve(self.href,'','XLink')
                newDoc = Domlette.NonvalidatingReader.parse(newSrc)
                child = doc.importNode(newDoc.documentElement,1)
                if resource.parentNode:
                    resource.parentNode.replaceChild(child, resource)
                else:
                    doc.replaceChild(child, resource)


class Extended(Literal):
    type = "extended"

class Locator(Literal):
    type = "locator"

class Arc(Literal):
    type = "arc"

class Resource(Literal):
    type = "resource"

class Title(Literal):
    type = "title"

TypeMap = {
    'simple' : Simple,
    'extended' : Extended,
    'locator' : Locator,
    'arc' : Arc,
    'resource' : Resource,
    'title' : Title,
    }

