########################################################################
#
# File Name:            Processor.py
#
# Documentation:        http://docs.4suite.org/4XLink/Processor.py.html
#
"""
Implement the XLink processor engine
WWW: http://4suite.org/4Link        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

#import string, os
import cStringIO
from Ft.Xml import Domlette
from Ft.Xml import XPath
from Ft.Xml.XLink import XLINK_NAMESPACE
from Ft.Xml.XLink import XLinkElements

class Processor:

    def run(self, iSrc):
        """
        Warning: The document will be modified in place
        The reader class MUST be able to support reading from href values.
        (i.e., URIs, but could be anything).
        """
        document = Domlette.NonvalidatingReader.parse(iSrc)
        context = XPath.CreateContext(document)
        context.processorNss.update({'xlink':XLINK_NAMESPACE})
        xlinks = XPath.Evaluate('/descendant-or-self::*[@xlink:type]', context=context)
        for link in xlinks:
            xlink = XLinkElements.Create(link, iSrc)
            xlink.process()
        return document
