########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/Lib/String.py,v 1.13 2003/08/20 19:29:36 mbrown Exp $
"""
This module supports misc XML-specific string functions

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import re

QNAME_PATTERN = None

_regexSetupCompleted = 0

def _initQNameRegex():
    """
    Called internally to compile the regular expressions needed by
    QName validation functions, just once, the first time a function
    that needs them is called.
    """
    global _regexSetupCompleted
    if _regexSetupCompleted:
        return

    # adapted from characters.py, generated by PyXML's xmlchargen.py,
    # based on definitions in XML 1.0 2nd Edition
    Letter = unicode('\x00A\x00-\x00Z\x00a\x00-\x00z\x00\xc0\x00-\x00\xd6\x00\xd8\x00-\x00\xf6\x00\xf8\x00-\x011\x014\x00-\x01>\x01A\x00-\x01H\x01J\x00-\x01~\x01\x80\x00-\x01\xc3\x01\xcd\x00-\x01\xf0\x01\xf4\x00-\x01\xf5\x01\xfa\x00-\x02\x17\x02P\x00-\x02\xa8\x02\xbb\x00-\x02\xc1\x03\x86\x03\x88\x00-\x03\x8a\x03\x8c\x03\x8e\x00-\x03\xa1\x03\xa3\x00-\x03\xce\x03\xd0\x00-\x03\xd6\x03\xda\x03\xdc\x03\xde\x03\xe0\x03\xe2\x00-\x03\xf3\x04\x01\x00-\x04\x0c\x04\x0e\x00-\x04O\x04Q\x00-\x04\\\x04^\x00-\x04\x81\x04\x90\x00-\x04\xc4\x04\xc7\x00-\x04\xc8\x04\xcb\x00-\x04\xcc\x04\xd0\x00-\x04\xeb\x04\xee\x00-\x04\xf5\x04\xf8\x00-\x04\xf9\x051\x00-\x05V\x05Y\x05a\x00-\x05\x86\x05\xd0\x00-\x05\xea\x05\xf0\x00-\x05\xf2\x06!\x00-\x06:\x06A\x00-\x06J\x06q\x00-\x06\xb7\x06\xba\x00-\x06\xbe\x06\xc0\x00-\x06\xce\x06\xd0\x00-\x06\xd3\x06\xd5\x06\xe5\x00-\x06\xe6\t\x05\x00-\t9\t=\tX\x00-\ta\t\x85\x00-\t\x8c\t\x8f\x00-\t\x90\t\x93\x00-\t\xa8\t\xaa\x00-\t\xb0\t\xb2\t\xb6\x00-\t\xb9\t\xdc\x00-\t\xdd\t\xdf\x00-\t\xe1\t\xf0\x00-\t\xf1\n\x05\x00-\n\n\n\x0f\x00-\n\x10\n\x13\x00-\n(\n*\x00-\n0\n2\x00-\n3\n5\x00-\n6\n8\x00-\n9\nY\x00-\n\\\n^\nr\x00-\nt\n\x85\x00-\n\x8b\n\x8d\n\x8f\x00-\n\x91\n\x93\x00-\n\xa8\n\xaa\x00-\n\xb0\n\xb2\x00-\n\xb3\n\xb5\x00-\n\xb9\n\xbd\n\xe0\x0b\x05\x00-\x0b\x0c\x0b\x0f\x00-\x0b\x10\x0b\x13\x00-\x0b(\x0b*\x00-\x0b0\x0b2\x00-\x0b3\x0b6\x00-\x0b9\x0b=\x0b\\\x00-\x0b]\x0b_\x00-\x0ba\x0b\x85\x00-\x0b\x8a\x0b\x8e\x00-\x0b\x90\x0b\x92\x00-\x0b\x95\x0b\x99\x00-\x0b\x9a\x0b\x9c\x0b\x9e\x00-\x0b\x9f\x0b\xa3\x00-\x0b\xa4\x0b\xa8\x00-\x0b\xaa\x0b\xae\x00-\x0b\xb5\x0b\xb7\x00-\x0b\xb9\x0c\x05\x00-\x0c\x0c\x0c\x0e\x00-\x0c\x10\x0c\x12\x00-\x0c(\x0c*\x00-\x0c3\x0c5\x00-\x0c9\x0c`\x00-\x0ca\x0c\x85\x00-\x0c\x8c\x0c\x8e\x00-\x0c\x90\x0c\x92\x00-\x0c\xa8\x0c\xaa\x00-\x0c\xb3\x0c\xb5\x00-\x0c\xb9\x0c\xde\x0c\xe0\x00-\x0c\xe1\r\x05\x00-\r\x0c\r\x0e\x00-\r\x10\r\x12\x00-\r(\r*\x00-\r9\r`\x00-\ra\x0e\x01\x00-\x0e.\x0e0\x0e2\x00-\x0e3\x0e@\x00-\x0eE\x0e\x81\x00-\x0e\x82\x0e\x84\x0e\x87\x00-\x0e\x88\x0e\x8a\x0e\x8d\x0e\x94\x00-\x0e\x97\x0e\x99\x00-\x0e\x9f\x0e\xa1\x00-\x0e\xa3\x0e\xa5\x0e\xa7\x0e\xaa\x00-\x0e\xab\x0e\xad\x00-\x0e\xae\x0e\xb0\x0e\xb2\x00-\x0e\xb3\x0e\xbd\x0e\xc0\x00-\x0e\xc4\x0f@\x00-\x0fG\x0fI\x00-\x0fi\x10\xa0\x00-\x10\xc5\x10\xd0\x00-\x10\xf6\x11\x00\x11\x02\x00-\x11\x03\x11\x05\x00-\x11\x07\x11\t\x11\x0b\x00-\x11\x0c\x11\x0e\x00-\x11\x12\x11<\x11>\x11@\x11L\x11N\x11P\x11T\x00-\x11U\x11Y\x11_\x00-\x11a\x11c\x11e\x11g\x11i\x11m\x00-\x11n\x11r\x00-\x11s\x11u\x11\x9e\x11\xa8\x11\xab\x11\xae\x00-\x11\xaf\x11\xb7\x00-\x11\xb8\x11\xba\x11\xbc\x00-\x11\xc2\x11\xeb\x11\xf0\x11\xf9\x1e\x00\x00-\x1e\x9b\x1e\xa0\x00-\x1e\xf9\x1f\x00\x00-\x1f\x15\x1f\x18\x00-\x1f\x1d\x1f \x00-\x1fE\x1fH\x00-\x1fM\x1fP\x00-\x1fW\x1fY\x1f[\x1f]\x1f_\x00-\x1f}\x1f\x80\x00-\x1f\xb4\x1f\xb6\x00-\x1f\xbc\x1f\xbe\x1f\xc2\x00-\x1f\xc4\x1f\xc6\x00-\x1f\xcc\x1f\xd0\x00-\x1f\xd3\x1f\xd6\x00-\x1f\xdb\x1f\xe0\x00-\x1f\xec\x1f\xf2\x00-\x1f\xf4\x1f\xf6\x00-\x1f\xfc!&!*\x00-!+!.!\x80\x00-!\x820\x070!\x00-0)0A\x00-0\x940\xa1\x00-0\xfa1\x05\x00-1,N\x00\x00-\x9f\xa5\xac\x00\x00-\xd7\xa3','utf-16-be')

    Digit = unicode('\x000\x00-\x009\x06`\x00-\x06i\x06\xf0\x00-\x06\xf9\tf\x00-\to\t\xe6\x00-\t\xef\nf\x00-\no\n\xe6\x00-\n\xef\x0bf\x00-\x0bo\x0b\xe7\x00-\x0b\xef\x0cf\x00-\x0co\x0c\xe6\x00-\x0c\xef\rf\x00-\ro\x0eP\x00-\x0eY\x0e\xd0\x00-\x0e\xd9\x0f \x00-\x0f)','utf-16-be')

    CombiningChar = unicode('\x03\x00\x00-\x03E\x03`\x00-\x03a\x04\x83\x00-\x04\x86\x05\x91\x00-\x05\xa1\x05\xa3\x00-\x05\xb9\x05\xbb\x00-\x05\xbd\x05\xbf\x05\xc1\x00-\x05\xc2\x05\xc4\x06K\x00-\x06R\x06p\x06\xd6\x00-\x06\xdc\x06\xdd\x00-\x06\xdf\x06\xe0\x00-\x06\xe4\x06\xe7\x00-\x06\xe8\x06\xea\x00-\x06\xed\t\x01\x00-\t\x03\t<\t>\x00-\tL\tM\tQ\x00-\tT\tb\x00-\tc\t\x81\x00-\t\x83\t\xbc\t\xbe\t\xbf\t\xc0\x00-\t\xc4\t\xc7\x00-\t\xc8\t\xcb\x00-\t\xcd\t\xd7\t\xe2\x00-\t\xe3\n\x02\n<\n>\n?\n@\x00-\nB\nG\x00-\nH\nK\x00-\nM\np\x00-\nq\n\x81\x00-\n\x83\n\xbc\n\xbe\x00-\n\xc5\n\xc7\x00-\n\xc9\n\xcb\x00-\n\xcd\x0b\x01\x00-\x0b\x03\x0b<\x0b>\x00-\x0bC\x0bG\x00-\x0bH\x0bK\x00-\x0bM\x0bV\x00-\x0bW\x0b\x82\x00-\x0b\x83\x0b\xbe\x00-\x0b\xc2\x0b\xc6\x00-\x0b\xc8\x0b\xca\x00-\x0b\xcd\x0b\xd7\x0c\x01\x00-\x0c\x03\x0c>\x00-\x0cD\x0cF\x00-\x0cH\x0cJ\x00-\x0cM\x0cU\x00-\x0cV\x0c\x82\x00-\x0c\x83\x0c\xbe\x00-\x0c\xc4\x0c\xc6\x00-\x0c\xc8\x0c\xca\x00-\x0c\xcd\x0c\xd5\x00-\x0c\xd6\r\x02\x00-\r\x03\r>\x00-\rC\rF\x00-\rH\rJ\x00-\rM\rW\x0e1\x0e4\x00-\x0e:\x0eG\x00-\x0eN\x0e\xb1\x0e\xb4\x00-\x0e\xb9\x0e\xbb\x00-\x0e\xbc\x0e\xc8\x00-\x0e\xcd\x0f\x18\x00-\x0f\x19\x0f5\x0f7\x0f9\x0f>\x0f?\x0fq\x00-\x0f\x84\x0f\x86\x00-\x0f\x8b\x0f\x90\x00-\x0f\x95\x0f\x97\x0f\x99\x00-\x0f\xad\x0f\xb1\x00-\x0f\xb7\x0f\xb9 \xd0\x00- \xdc \xe10*\x00-0/0\x990\x9a','utf-16-be')

    Extender = unicode('\x00\xb7\x02\xd0\x02\xd1\x03\x87\x06@\x0eF\x0e\xc60\x0501\x00-050\x9d\x00-0\x9e0\xfc\x00-0\xfe','utf-16-be')

    # from http://www.w3.org/TR/REC-xml-names
    # [5]  NCNameChar ::=  Letter | Digit | '.' | '-' | '_' | CombiningChar | Extender
    # [4]  NCName ::=  (Letter | '_') (NCNameChar)* /*  An XML Name, minus the ":" */
    # [7]  Prefix ::=  NCName
    # [8]  LocalPart ::=  NCName
    # [6]  QName ::=  (Prefix ':')? LocalPart
    NCNameChar = r'[%s%s\.\-_%s%s]' % (Letter, Digit, CombiningChar, Extender)
    Prefix = LocalPart = NCName = r'[%s_]%s*' % (Letter, NCNameChar)
    QNAME_REGEX = QName = r'(?:%s:)?%s' % (Prefix, LocalPart)

    global QNAME_PATTERN
    QNAME_PATTERN = re.compile(QNAME_REGEX)
    _regexSetupCompleted = 1
    return


def IsQName(s):
    """
    Returns true if the given string is a QName as defined by the
    W3C's Namespaces in XML Recommendation.
    """
    _initQNameRegex()
    return QNAME_PATTERN.match(s) is not None
