########################################################################
#
# File Name:            TestTree.py
#
#
"""

Create a tree for testing

WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Xml import XMLNS_NAMESPACE, EMPTY_NAMESPACE, EMPTY_PREFIX
from DomTree import *

def TestTree():
    """Function used to create a tree for testing"""
    doc = Document('document-uri')
    pi = ProcessingInstruction('xml-stylesheet','href="addr_book1.xsl" type="text/xml"')
    pi.ownerDocument = doc
    doc.childNodes.append(pi)
    pi.parentNode = doc
    doc.firstChild = pi

    rootelem = Element('docelem', EMPTY_NAMESPACE,EMPTY_PREFIX,'docelem')
    rootelem.ownerDocument = doc
    doc.childNodes.append(rootelem)
    rootelem.parentNode = doc
    doc.lastChild = rootelem
    doc.documentElement = rootelem
    rootelem.previousSibling = pi
    pi.nextSibling = rootelem


    #Setup the root elem
    attr = Attr('xmlns:ft',XMLNS_NAMESPACE,'xmlns','ft','http://fourthought.com')
    attr.ownerDocument = doc
    rootelem.attributes[(XMLNS_NAMESPACE, 'ft')] = attr
    attr.ownerElement = attr.parentNode = rootelem

    text = Text('\n  ')
    text.ownerDocument = doc
    rootelem.childNodes.append(text)
    text.parentNode = rootelem
    rootelem.firstChild = text

    fChild = Element('child', EMPTY_NAMESPACE,EMPTY_PREFIX,'child')
    fChild.ownerDocument = doc
    rootelem.childNodes.append(fChild)
    text.nextSibling = fChild
    fChild.previousSibling = text
    fChild.parentNode = rootelem
    #Add attrs and children
    attr = Attr('foo', EMPTY_NAMESPACE,EMPTY_PREFIX,'foo','bar')
    attr.ownerDocument = doc
    fChild.attributes[(None,'foo')] = attr
    attr.ownerElement = attr.parentNode = fChild

    sText = Text('Some Text')
    sText.ownerDocument = doc
    sText.parnetNode = fChild
    fChild.childNodes.append(sText)
    sText.parentNode = fChild
    fChild.firstChild = fChild.lastChild = sText


    text = Text('\n  ')
    text.ownerDocument = doc
    rootelem.childNodes.append(text)
    text.parentNode = rootelem
    text.previousSibling = fChild
    fChild.nextSibling = text

    comment = Comment('A comment')
    comment.ownerDocument = doc 
    rootelem.childNodes.append(comment)
    comment.parentNode = rootelem
    comment.previousSibling = text
    text.nextSibling = comment


    text = Text('\n  ')
    text.ownerDocument = doc 
    rootelem.childNodes.append(text)
    text.parentNode = rootelem
    text.previousSibling = comment
    comment.nextSibling = text

    sChild = Element('ft:nschild', 'http://fourthought.com', 'ft','nschild')
    sChild.ownerDocument = doc
    rootelem.childNodes.append(sChild)
    sChild.parentNode = rootelem
    text.nextSibling = sChild
    sChild.previousSibling = text
    #Add attrs and children
    attr = Attr('ft:foo', 'http://fourthought.com', 'ft', 'foo', 'nsbar')
    attr.ownerDocument = doc
    sChild.attributes[('http://fourthought.com', 'foo')] = attr
    attr.ownerElement = attr.parentNode = sChild
    sText = Text('Some More Text')
    sText.ownerDocument = doc 
    sChild.childNodes.append(sText)
    sText.parentNode = sText
    sChild.firstChild = sChild.lastChild = sText


    text = Text('\n  ')
    text.ownerDocument = doc
    rootelem.childNodes.append(text)
    text.parentNode = rootelem
    text.previousSibling = sChild
    sChild.nextSibling = text

    aChild = Element('appendChild', EMPTY_NAMESPACE,EMPTY_PREFIX,'appendChild')
    aChild.ownerDocument = doc
    rootelem.childNodes.append(aChild)
    aChild.parentNode = rootelem
    text.nextSibling = aChild
    aChild.previousSibling = text

    text = Text('\n  ')
    text.ownerDocument =  doc
    rootelem.childNodes.append(text)
    text.parentNode = rootelem
    text.previousSibling = aChild
    aChild.nextSibling = text
    rootelem.lastChild = text


    return doc
##DOC = """<?xml version = "1.0"?>
##<?xml-stylesheet href="addr_book1.xsl" type="text/xml"?>
##<docelem xmlns:ft='http://fourthought.com'>
##  <child foo='bar'>Some Text</child>
##  <!--A comment-->
##  <ft:nschild ft:foo='nsbar'>Some More Text</ft:nschild>
##  <appendChild/>
##</docelem>
##"""
