<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:f="http://xmlns.4suite.org/ext" 
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:func="http://exslt.org/functions"
  xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
  xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#"
  xmlns:dc="http://purl.org/dc/elements/1.1/"
  xmlns:xhtml="http://www.w3.org/1999/xhtml"
  xmlns:g="http://xmlns.4suite.org/demo/genitive" 
  extension-element-prefixes="f frdf func"
>
  
  <!--  -->

  <func:function name="g:resource-label">
    <xsl:param name="resource"/>
    <xsl:variable name="resource-label-result" f:node-set="yes">
      <frdf:versa-query query="@'{$resource}' - set(dc:title, rdfs:label) -> *"/>
    </xsl:variable>

    <xsl:variable name="result" f:node-set="yes">
      <xsl:choose>
        <xsl:when test="$resource-label-result/List/*">
          <xsl:value-of select="$resource-label-result/List[1]/*"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$resource"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <func:result select='$result'/>
  </func:function>
  
</xsl:stylesheet>
