<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  menu-includes.xslt

Description:

    Common templates to generate the document framework and menu bars.

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <!-- parameters passed in from the HTTP interface to the repo -->
  <xsl:param name="fres:uri-path"/>
  <xsl:param name="fres:xslt-uri"/>

  <xsl:output method="html" encoding="iso-8859-1"/>

  <xsl:template name="menus">
    <xsl:param name="expired"/>
    <xsl:param name="include-javascript"/>
    <xsl:param name="pageTitle"/>
    <html>
      <head>
        <title>
          <xsl:value-of select="$pageTitle"/>
        </title>
        <link rel="stylesheet" type="text/css" href="/buyerbase/bb-netscape.css"/>
        <script language="JavaScript1.2" type="text/javascript">
          <xsl:comment>&#10;      if (document.all) document.createStyleSheet("/buyerbase/bb-ie.css");//</xsl:comment>
        </script>
        <xsl:if test="$include-javascript">
          <script language="JavaScript1.2" type="text/javascript">
            <xsl:comment>
      function confirmRecordDelete( name ){
       if( !confirm('Are you sure you want to delete this ' + escape(name) + '?')){
         return false;
       }
       else {
         document.main.actionToDo.value = 'delete';
         document.main.submit();
       }
     }
      function validateQty(){
       if( document.main.qty.value &gt; 0 ){
         document.main.actionToDo.value = 'add';
         document.main.submit();
       }
       else {
         alert('Quantity must be greater than zero!');
         return false;
       }
     }
             //</xsl:comment>
          </script>
        </xsl:if>
      </head>
      <body leftmargin="0" topmargin="0" width="700" class="normal">
        <table cellspacing="0" width="700" height="100%" cellpadding="5">
          <tr class="cellRed" valign="middle" align="center" height="40">
            <td width="695" class="logo" colspan="2">
              <p style="line-height: 150%">
                <i>
                  <font color="#FFFFFF">Buyer Base</font>
                </i>
              </p>
            </td>
          </tr>
          <tr class="cellGray" valign="middle" align="center" height="20">
            <td colspan="2">
              <div class="normal" style="padding-top: 2px; padding-bottom: 2px; color: #333">
                <xsl:text>[ </xsl:text>
                <xsl:choose>
                  <xsl:when test="fcore:has-session()">
                    <i>
                      <xsl:text>You are logged in as </xsl:text>
                      <b>
                        <xsl:value-of select="fcore:get-current-username()"/>
                      </b>
                    </i>
                  </xsl:when>
                  <xsl:when test="$expired">
                    <i>You were logged out due to inactivity. You must log in again.</i>
                  </xsl:when>
                  <xsl:otherwise>
                    <i>You are not logged in</i>
                  </xsl:otherwise>
                </xsl:choose>
                <xsl:text> ]</xsl:text>
              </div>
            </td>
          </tr>
          <tr>
            <td width="5">&nbsp;</td>
            <td valign="top" align="left" width="695">
              <xsl:call-template name="body"/>
            </td>
          </tr>
          <tr>
            <td colspan="2" height="38">&nbsp;</td>
          </tr>
          <tr valign="bottom">
            <td class="left-sub-list" align="center" colspan="2">
              <br/>
              <hr/>
              <div style="font-size: 8pt; color: #444">
                <xsl:choose>
                  <xsl:when test="substring($fres:uri-path,string-length($fres:uri-path),1) != '/'">
                    <xsl:text>Behind the scenes: view the </xsl:text>
                    <a style="font-weight: bold; color: maroon" href="{$fres:uri-path}" target="window2">XML source</a>
                    <xsl:if test="$fres:xslt-uri">
                      <xsl:text> or the </xsl:text>
                      <a style="font-weight: bold; color: maroon" href="{$fres:xslt-uri}" target="window2">XSLT stylesheet</a>
                    </xsl:if>
                    <xsl:text> that generated this page.</xsl:text>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:text>Behind the scenes: view the </xsl:text>
                    <a style="font-weight: bold; color: maroon" href="{$fres:xslt-uri}" target="window2">XSLT stylesheet</a>
                    <xsl:text> that generated this page (the XML source is arbitrary).</xsl:text>
                  </xsl:otherwise>
                </xsl:choose>
              </div>
              <hr/>
              <xsl:text>&#169; 2004 Fourthought, Inc.</xsl:text>
            </td>
          </tr>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
