########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/XmlDocument.py,v 1.4 2004/07/03 04:14:34 mbrown Exp $
"""
XSLT extensions providing repository functionality related to
XmlDocument objects

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ns import SCORE_NS
import FtssXsltBase
from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, ContentInfo, AttributeInfo



def GetDocumentDefinition(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)
    dd = base.getDocumentDefinition()
    if dd is None: return ""
    return dd.getAbsolutePath()

class SetDocumentDefinitionElement(XsltElement):
    """
    Change the Document Definition of a XML document
    """
    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(
        default=None,
        description='The path of the resource to change the IMT of.  Defaults to current.'),
        'docdef' : AttributeInfo.StringAvt(required=1,
                                           description='The new Document Definition'),
        }

    def instantiate(self, context, processor):
        context.setProcessState(self)
        # This may return None (the 'default' from AttributeInfo)
        path          = self._path.evaluate(context)
        dd          = self._docdef.evaluate(context)
        
        obj = FtssXsltBase.FetchBaseObject(processor, path)
        if dd == "":
            obj.setDocumentDefinition(None)
        else:
            docdef = obj.fetchResource(dd);
            obj.setDocumentDefinition(docdef)

        return (context,)



ExtFunctions = {
    (SCORE_NS, 'get-document-definition'): GetDocumentDefinition,    
}

ExtElements = {
#    (NS, 'repo-text-reindex'): TextReindexRepositoryElement,
    (SCORE_NS, 'set-document-definition'): SetDocumentDefinitionElement,    
}
