########################################################################
#
# File Name:            RawFile.py
#
"""
XSLT and XPath extensions supporting the 4SS rawFile API
WWW: http://4suite.org        e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ns import SCORE_NS
import FtssXsltBase
from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, ContentInfo, AttributeInfo



def GetImt(context,path=None):
    """
    Get the imt of the resource
    """
    path = Conversions.StringValue(path)
    #print path
    return FtssXsltBase.FetchBaseObject(context.processor,path).getImt()


class SetImtElement(XsltElement):
    """
    Change the IMT of a resource
    """
    content = None

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(
        default=None,
        description='The path of the resource to change the IMT of.  Defaults to current.'),
        'imt' : AttributeInfo.StringAvt(required=1,
                                        description='The new IMT'),
        }

    def instantiate(self, context, processor):
        context.setProcessState(self)

        # This may return None (the 'default' from AttributeInfo)
        path          = self._path.evaluate(context)
        imt          = self._imt.evaluate(context)
        
        obj = FtssXsltBase.FetchBaseObject(processor, path)
        obj.setImt(imt)

        return (context,)



ExtFunctions = {
    (SCORE_NS, 'get-imt'): GetImt,    
#    (NS, 'repo-user-name'): RepoUserName,    
}

ExtElements = {
#    (NS, 'repo-text-reindex'): TextReindexRepositoryElement,
    (SCORE_NS, 'set-imt'): SetImtElement,    
}
