########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/Http.py,v 1.22 2003/04/21 03:23:45 mbrown Exp $
"""
XSLT and XPath extensions for use to access the 4SS API

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import types

from Ns import HTTP_NS

from Ft.Server import RESERVED_NAMESPACE
from Ft.Xml.Lib.String import IsQName
from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, ContentInfo, AttributeInfo

def LocalPath(context, path):
    path = Conversions.StringValue(path)
    handler = context.processor.extensionParams[(RESERVED_NAMESPACE, 'handler')]

    docRoot = handler.documentRoot
    if docRoot and path[:len(docRoot)] == docRoot:
        path = path[len(docRoot):]
    return path


def GetQueryArguments(context):
    """
    fhttp:get-query-args() returns a node-set consisting of
    one 'requestParameters' element, containing one child
    element for each item in the HTTP request parameters,
    a.k.a. the query arguments (typically HTML form data).

    The HTTP server will have already decoded the parameters
    and made them available to the XSLT processor; this
    function merely provides access to that data as a
    node-set. The parameter name becomes the element name,
    and the value is the element's content. If there are
    multiple parameters with the same name, they'll manifest
    as separate elements.
    """
    queryArgs = context.processor.extensionParams[(RESERVED_NAMESPACE,'queryArgs')]
    proc = context.processor
    proc.pushResultTree(context.currentInstruction.baseUri)
    try:
        proc.writers[-1].startElement('requestParameters')
        for name, values in queryArgs.items():
            #print "(%s,%s)"%(name,repr(values))
            # colons and characters not allowed in
            # XSLT parameter names become hyphens.
            if name.find(u':') != -1:
                name = name.replace(u':', u'-')
            if not IsQName(name):
                newname = u''
                for c in name:
                    if not IsQName(c):
                        c = u'-'
                    newname += c
                name = newname
                del newname
            for value in values:
                proc.writers[-1].startElement(name)
                proc.writers[-1].text(value)
                proc.writers[-1].endElement(name)
        proc.writers[-1].endElement('requestParameters')
    finally:
        rtf = proc.popResult()
    return rtf.childNodes


class ResponseUriElement(XsltElement):

    content = ContentInfo.Empty
    legalAttrs = {
        'uri' : AttributeInfo.UriReferenceAvt(required=1,
                                              description='The uri to use for '
                                              'the response redirect.'),
        }

    childArgument = None

    def instantiate(self, context, processor):
        context.setProcessState(self)
        #wrappedAvt = AttributeInfo.ExpressionWrapper(self._uri, self, self._uri.source)
        #uri = wrappedAvt.evaluate(context)
        uri = self._uri.evaluate(context)
        context.processor.extensionParams[(RESERVED_NAMESPACE, 'response-uri')] = uri
        return (context,)


class RequestHeadersElement(XsltElement):

    content = ContentInfo.Empty
    legalAttrs = {}

    def instantiate(self, context, processor):
        handler = context.processor.extensionParams.get((RESERVED_NAMESPACE,
                                                         'handler'))
        for k, v in handler.headers_in.items():
            processor.writers[-1].startElement('Header')
            processor.writers[-1].startElement('Name')
            processor.writers[-1].text(k)
            processor.writers[-1].endElement('Name')
            if type(v) != types.ListType:
                v = [v]
            for actual in v:
                processor.writers[-1].startElement('Value')
                processor.writers[-1].text(actual)
                processor.writers[-1].endElement('Value')
            processor.writers[-1].endElement('Header')
        return (context,)


ExtElements = {
    (HTTP_NS, 'response-uri'): ResponseUriElement,
    (HTTP_NS, 'request-headers') : RequestHeadersElement,
    }

ExtFunctions = {
    (HTTP_NS, 'local-path'): LocalPath,
    (HTTP_NS, 'get-query-args'): GetQueryArguments,
    }
