import os
from Ft.Server.Server import FTSERVER_SERVER_NS, Module
import Basic

from Ft.Server.Common import Schema
from Ft.Server import SCHEMA_NSS

class HttpModule(Module):

    commands = {
        (FTSERVER_SERVER_NS, 'DocumentRoot'): 'setDocumentRoot',
        (FTSERVER_SERVER_NS, 'Redirect'): 'setRedirect',
        (FTSERVER_SERVER_NS, 'AuthName'): 'setAuthName',
        (FTSERVER_SERVER_NS, 'MandatoryAuth'): 'setMandatoryAuth',
        (FTSERVER_SERVER_NS, 'DefaultXslt'): 'setDefaultXslt',
        (FTSERVER_SERVER_NS, 'SessionMethod'): 'setSessionMethod',
        (FTSERVER_SERVER_NS, 'SessionUserName'): 'setSessionUserName',
        (FTSERVER_SERVER_NS, 'SessionPassword'): 'setSessionPassword',
        (FTSERVER_SERVER_NS, 'SessionTtl'): 'setSessionTtl',
        (FTSERVER_SERVER_NS, 'SessionAnonymousFlag'): 'setSessionAnonymousFlag',
        (FTSERVER_SERVER_NS, 'SessionInvalidUri'): 'setSessionInvalidUri',
        (FTSERVER_SERVER_NS, 'SessionLoginUri'): 'setSessionLoginUri',
        (FTSERVER_SERVER_NS, 'SessionInvalidLoginUri'): 'setSessionInvalidLoginUri',
        (FTSERVER_SERVER_NS, 'SessionPermissionDeniedUri'): 'setSessionPermissionDeniedUri',
        (FTSERVER_SERVER_NS, 'Rule'): 'setRule',
        (FTSERVER_SERVER_NS, 'HttpPostEncodingVar'): 'setHttpPostEncodingVar',
        }

    handlers = {'http_basic' : Basic.BasicHttpHandler}

    def setDocumentRoot(self, parser, config, name, data, attrs):
        if not data:
            raise Exception('%s requires path argument' % name)

        if data[0] != '/':
            raise Exception('%s path must be absolute' % name)

        # Normalize it, borrowed mostly from posixpath.normpath()
        steps = []
        comps = data.split('/')
        for comp in comps:
            if comp in ('', '.'):
                # Either a duplicate slash ('') or a do nothing step
                continue
            if comp != '..':
                steps.append(comp)
            elif steps:
                # A dot-dot, remove previous path
                steps.pop()
        path = '/'.join(steps)
        if path:
            config.documentRoot = '/' + path
        else:
            config.documentRoot = ''
        return

    def setRedirect(self, parser, config, name, data, attrs):
        if not data:
            raise Exception('%s requires path argument' % name)

        if not attrs.has_key('src'):
            raise Exception('%s must have src attribute' % name)

        src = attrs['src']
        if not src[0] == '/':
            raise Exception('%s src must be absolute' % name)
        
        if not hasattr(config, 'redirects'):
            config.redirects = {}

        config.redirects[src] = data
        return

    def setAuthName(self, parser, config, name, data, attrs):
        config.authName = data
        return

    def setMandatoryAuth(self, parser, config, name, data, attrs):
        config.mandatoryAuth = data
        return

    def setDefaultXslt(self, parser, config, name, data, attrs):
        if not hasattr(config, 'defaultXslt'):
            config.defaultXslt = {}

        typ = SCHEMA_NSS + attrs['type']
        rt = Schema.g_resourceTypeFromRdf.get(typ)
        if rt:
            config.defaultXslt[rt] = str(data)
        else:
            print "Unknown Type mapping: %s" % attrs['type']
        return

    def setSessionMethod(self, parser, config, name, data, attrs):
        config.session_method = data
        return

    def setSessionUserName(self, parser, config, name, data, attrs):
        config.session_user_name = data
        return

    def setSessionPassword(self, parser, config, name, data, attrs):
        config.session_password = data
        return

    def setSessionTtl(self, parser, config, name, data, attrs):
        config.session_ttl = data
        return

    def setSessionAnonymousFlag(self, parser, config, name, data, attrs):
        config.session_anonymous_flag = data
        return

    def setSessionInvalidUri(self, parser, config, name, data, attrs):
        config.session_invalid_uri = data
        return

    def setSessionPermissionDeniedUri(self, parser, config, name, data, attrs):
        config.session_permission_denied_uri = data
        return

    def setSessionLoginUri(self, parser, config, name, data, attrs):
        config.session_post_login_uri_qs = data
        return

    def setSessionInvalidLoginUri(self, parser, config, name, data, attrs):
        config.session_post_invalid_login_uri_qs = data
        return

    def setRule(self, parser, config, name, data, attrs):
        if not hasattr(config, 'processing_rules'):
            config.processing_rules = []
        config.processing_rules.append((attrs['pattern'],
                                        attrs.get('xslt-source'),
                                        attrs['xslt-transform'],
                                        attrs.get('extra-args', ''),
                                        attrs.get('chain-multiple-transforms', 'yes')
                                        ))
        return

    def setHttpPostEncodingVar(self, parser, config, name, data, attrs):
        config.http_post_encoding_var = data
        return

    
## This stuff needs to be added to the HttpModule

##class ConfigParser(BaseConfigParser):

##    entries = BaseConfigParser.entries + ['LogFormat',
##                                          'TransferLog']

##    required_entries = BaseConfigParser.required_entries + ['DocumentRoot']

##    # Overridden
##    def setup(self):
##        # Ensure that these will be in list format
##        self.config['LogFormat'] = []
##        self.config['TransferLog'] = []
##        return

##    # Overridden
##    def finish(self):
##        self._finish_formats()
##        self._finish_logs()
##        return

##    def handle_LogFormat(self, node):
##        name = node.getAttributeNS('', 'name')
##        if not name:
##            print 'LogFormat missing (or empty) required name attribute'
##            return
##        format = self._handle_unknown(node)
##        if not format:
##            return None
##        return (name, format)

##    def handle_TransferLog(self, node):
##        format = node.getAttributeNS('', 'format')
##        if not format:
##            format = 'common'
##        logfile = self._handle_unknown(node)
##        if not logfile:
##            return None
##        return (format, logfile)

##    def _finish_formats(self):
##        log_formats = self.config['LogFormat']
##        formats = {}
##        for name, format in log_formats:
##            formats[name] = format

##        # Add default formats if not already provided
##        if not formats.has_key('common'):
##            formats['common'] = TransferLog.COMMON_LOG_FORMAT
##        if not formats.has_key('combined'):
##            formats['combined'] = TransferLog.COMBINED_LOG_FORMAT

##        self.config['LogFormat'] = formats
##        return

##    def _finish_logs(self):
##        # Make sure that the log formats are already processed
##        if type(self.config['LogFormat']) is not type({}):
##            self._finish_formats()

##        formats = self.config['LogFormat']
##        transfers = self.config['TransferLog']
##        accesses = []
##        for name, filename in transfers:
##            # The controller ensures that each filename has only one lock
##            # and that the filename is absolute
##            filename, lock = self.controller.getFileLock(filename)
##            format, fields = TransferLog.MakeFormatString(formats[name])
##            accesses.append((filename, lock, format, fields))

##        self.config['TransferLog'] = accesses
##        return

