import os
from Ft.Server.Server import FTSERVER_SERVER_NS, Module

from Ft.Server.Common import Schema
from Ft.Server import SCHEMA_NSS

import Handler

class SoapModule(Module):

    commands = {
        (FTSERVER_SERVER_NS, 'DocumentRoot'): 'setDocumentRoot',
        (FTSERVER_SERVER_NS, 'AuthName'): 'setAuthName',
        }

    handlers = {'basic_soap' : Handler.SoapHandler}


    def setDocumentRoot(self, parser, config, name, data,attrs):
        if not data:
            raise Exception('%s requires path argument' % name)

        if data[0] != '/':
            raise Exception('%s path must be absolute' % name)

        # Normalize it, borrowed mostly from posixpath.normpath()
        steps = []
        comps = data.split('/')
        for comp in comps:
            if comp in ('', '.'):
                # Either a duplicate slash ('') or a do nothing step
                continue
            if comp != '..':
                steps.append(comp)
            elif steps:
                # A dot-dot, remove previous path
                steps.pop()
        path = '/'.join(steps)
        if path:
            config.documentRoot = '/' + path
        else:
            config.documentRoot = ''
        return
    

    def setAuthName(self, parser, config, name, data,attrs):
        config.authName = data
        return

    
