from Ft.Server.Server import FTSERVER_SERVER_NS, Module
import FtpHandler

class FtpModule(Module):

    handlers = {'ftp' : FtpHandler.FtpHandler}


    commands = {
        (FTSERVER_SERVER_NS, 'ExtendedMapping'): 'addExtendedMapping',
        }

    def addExtendedMapping(self, parser, config, name, data,attrs):
        """
        An extended mapping will map an extension to IMT, docdef, or resource type
        """
        if not hasattr(config,'extendedMapping'):
            config.extendedMapping = {}

        ext = attrs.get('ext',None)
        if ext is None:
            raise Exception('%s requires ext attribute' % name)

        dd = attrs.get('doc-def',None)
        imt = attrs.get('imt',None)
        rt = attrs.get('resource-type',None)

        if (dd,imt,rt) == (None,None,None):
            raise Exception("%s requires on of either doc-def, imt, or resource-type" % name)

        config.extendedMapping[ext] = (dd,imt,rt)
