<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
  <!--
File:  menu-includes.xslt

Description:

   4Suite Repository Dashboard
   Templates for the generic page framework including the menu sidebar

Copyright 2004 Fourthought Inc, USA.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->
  <xsl:output method="html" indent="yes"/>
  <xsl:template name="menus">
    <!-- top nav -->
    <xsl:param name="displayName"/>
    <xsl:param name="help-reference"/>
    <xsl:param name="additional-style" select='0'/>
    <html>
      <head>
        <title>View <xsl:value-of select="$displayName"/>
        </title>
        <link type="text/css" rel="Stylesheet" href="/ftss/dashboard/4ss-netscape.css"/>
        <script language="JavaScript1.2" type="text/javascript">
          <xsl:comment>&#10;      if (document.all) document.createStyleSheet("4ss.css");&#10;      //</xsl:comment>
        </script>
        <xsl:if test='$additional-style'>
          <link type="text/css" rel="stylesheet" href="{$additional-style}"/>
        </xsl:if>
      </head>
      <body leftmargin="0" topmargin="0" class="normal">
        <table class="normal" cellspacing="0" cellpadding="0">
          <tr>
            <td colspan="4">
              <table width="100%" border="1">
                <tr>
                  <td class="titleBar" align="middle">4Suite Repository Dashboard ( logged in as <strong>
                      <xsl:value-of select="fcore:get-current-username()"/>
                    </strong> )</td>
                </tr>
              </table>
            </td>
          </tr>
          <tr>
            <td class="cellGray">&#160;</td>
            <td class="cellGray" valign="top" align="left">
              <table cellspacing="0" width="120" cellpadding="4">
                <!--
                <tr>
                  <td class="left-list">
                    <img src="/ftss/dashboard/images/4suite-org2.gif" width="116" height="42"/>
                  </td>
                </tr> -->
                <!--left menu-->
                <xsl:call-template name="left-menu">
                  <xsl:with-param name="help-reference" select="$help-reference"/>
                </xsl:call-template>
                <tr valign="bottom">
                  <td class="left-list" align="center">
                    <p>
                      <a href="http://4suite.org/" target="_new">
                        <img alt="Powered By 4Suite" src="/ftss/dashboard/images/poweredby_4ss.png" border="0" width="150" height="65"/>
                      </a>
                    </p>
                  </td>
                </tr>
              </table>
            </td>
            <!--end left menu-->
            <!--body content -->
            <td width="5">&#160;</td>
            <td valign="top">
              <form method="post" action="/?xslt=/ftss/dashboard/manager.xslt" enctype="multipart/form-data">
                <input type="hidden" name="managedResourcePath" value="{$resourcePath}"/>
                <!--
                <xsl:for-each select="fhttp:get-query-args()">
                  <xsl:message><xsl:copy-of select="."/></xsl:message>
                </xsl:for-each>
                <xsl:message>
                  <xsl:value-of select="fhttp:get-query-args()//genericManage"/>
                </xsl:message>-->
                <xsl:choose>
                  <xsl:when test="fhttp:get-query-args()//cwd">
                    <xsl:choose>
                      <xsl:when test="document('/ftss/dashboard/DashboardConfig.xml')/DashboardConfig/DefaultManager = 'Basic'">
                        <fhttp:response-uri uri="{fhttp:get-query-args()//absolutePath}?basic=1"/>
                      </xsl:when>
                      <xsl:otherwise>
                        <fhttp:response-uri uri="{fhttp:get-query-args()//absolutePath}"/>
                      </xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:when test="$genericManage">
                    <xsl:call-template name="genericManager"/>
                  </xsl:when>
                  <xsl:when test="$action">
                    <xsl:call-template name="processAction"/>
                  </xsl:when>
                  <xsl:otherwise>
                    <table cellpadding="4" cellspacing="1" class="normal">
                      <tr>
                        <td class="titleBar">
                          <xsl:value-of select="$displayName"/> Manager</td>
                      </tr>
                      <tr>
                        <td>
                          <span class="blackTitle">
                            <xsl:value-of select="$displayName"/> path:</span>
                          <span class="path">
                            <xsl:call-template name="PathLink">
                              <xsl:with-param name="path" select="$resourcePath"/>
                            </xsl:call-template>
                          </span>
                          <xsl:if test='$resourcePath != "/" and not(fhttp:get-query-args()//metaContainer)'>
                            <xsl:text>&#160;&#160;&#160;</xsl:text>
                            <a href="{fcore:get-parent($resourcePath)}">
                              <img src="/ftss/data/icons/back.gif" border="0"/>
                            </a>
                            <xsl:text> - (manage parent container)</xsl:text>
                          </xsl:if>
                        </td>
                      </tr>
                      <tr>
                        <td class="blackTitle">
                          <input type="text" size="40" name="absolutePath" value="{$resourcePath}"/>&nbsp;<input type="submit" name="cwd" value="Change Directory"/>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <xsl:if test="not(fhttp:get-query-args()//metaContainer)">
                            <xsl:if test='not($resourceType = "http://schemas.4suite.org/4ss#container")'>
                              <input type="submit" value="View {$displayName} Data" name="genericManage" class="button"/>
                            </xsl:if>
                            <xsl:if test='($resourceType = "http://schemas.4suite.org/4ss#repository" or $resourceType = "http://schemas.4suite.org/4ss#container"  or $resourceType = "http://schemas.4suite.org/4ss#server"  or $resourceType = "http://schemas.4suite.org/4ss#user"  or  $resourceType = "http://schemas.4suite.org/4ss#group") and not(fhttp:get-query-args()//basic)'>
                              <input type="submit" value="Edit {$displayName} XML" name="genericManage" class="button"/>
                            </xsl:if>
                            <input type="submit" value="View {$displayName} Meta Data Graph (Triclops)" name="genericManage" class="button"/>
                          </xsl:if>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <hr/>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <xsl:call-template name="body"/>
                        </td>
                      </tr>
                    </table>
                  </xsl:otherwise>
                </xsl:choose>
              </form>
            </td>
          </tr>
          <!--end body content -->
          <!-- bottom nav -->
          <xsl:if test="fhttp:get-query-args()//dashboard-message">
            <tr valign="bottom">
              <td class="cellGray"/>
              <td class="cellGray">&#160;</td>
              <td colspan="2" align="center" class="left-sub-list">
                <span class="message">
                  <img src="/ftss/data/icons/alert.red.gif"/>
                  <em>
                    <xsl:value-of select="fhttp:get-query-args()//dashboard-message"/>
                  </em>
                </span>
              </td>
            </tr>
          </xsl:if>
          <tr valign="bottom">
            <td class="cellGray">&#160;</td>
            <td rowspan="2" class="cellGray" valign="bottom">&#160;</td>
            <td colspan="2" align="center" class="left-sub-list">
              <hr/>
              <xsl:text>Copyright 2003 Fourthought, Inc.</xsl:text>
            </td>
          </tr>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="left-menu">
    <xsl:param name="help-reference"/>
    <!-- FIX ME all the following items need to be links-->
    <tr>
      <td class="left-list">
        <a href="/?xslt=/ftss/dashboard/ServerFiles.xslt&amp;type=servers&amp;metaContainer=1">Servers</a>
      </td>
    </tr>
    <tr>
      <td class="left-list">
        <hr/>
        <a href="/?xslt=/ftss/dashboard/ServerFiles.xslt&amp;type=users&amp;metaContainer=1">Users</a>
      </td>
    </tr>
    <tr>
      <td class="left-list">
        <hr/>
        <a href="/?xslt=/ftss/dashboard/ServerFiles.xslt&amp;type=groups&amp;metaContainer=1">Groups</a>
      </td>
    </tr>
    <tr>
      <td class="left-list">
        <hr/>
        <a href='/?xslt=/ftss/dashboard/Triclops.xslt&amp;versa-query=@"{$resourcePath}"&amp;manageable=1&amp;queryType=Triple' target="triclops">Metadata Search</a>
      </td>
    </tr>
    <tr>
      <td class="left-list">
        <hr/>
        <a href="/">Repository</a>
      </td>
    </tr>
    <tr>
      <td class="left-list">
        <hr/>
        <a href="/ftss/dashboard/DashboardConfig.xml?action=configForm">Configure</a>
      </td>
    </tr>
    <xsl:if test='$help-reference'>
      <tr>
        <td class="left-list">
          <hr/>
          <a onclick="javascript:window.open('/ftss/docs/?xslt=/ftss/dashboard/help.xslt&amp;help-reference={$help-reference}','DashboardHelp','toolbar=no,scrollbars=yes,width=700,height=500')" href="#">Help</a>
        </td>
      </tr>
    </xsl:if>
    <tr>
      <td class="left-list">
        <hr/>
        <xsl:choose>
          <xsl:when test='fcore:has-resource("/ftss/docs/index.doc")'>
            <a href="/ftss/docs/index.doc?xslt=/ftss/dashboard/docs-index.xslt">4Suite Docs</a>
          </xsl:when>
          <xsl:otherwise>
            <a href="/ftss/docs/?xslt=/ftss/dashboard/no-docs.xslt">4Suite Docs</a>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </tr>
  </xsl:template>

  <xsl:template name="PathLink">
    <xsl:param name="path"/>
    <xsl:param name="parent"/>
    <xsl:variable name="preSlashPath" select="substring-before($path,'/')"/>
    <xsl:variable name="postSlashPath" select="substring-after($path,'/')"/>
    <xsl:choose>
      <xsl:when test="$postSlashPath">
        <a href="{concat($parent,'/',$preSlashPath)}">
          <xsl:value-of select="$preSlashPath"/>
        </a>
      </xsl:when>
      <xsl:when test="$preSlashPath">
        <xsl:value-of select="$preSlashPath"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$path"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="$postSlashPath">/</xsl:if>
    <xsl:if test="$postSlashPath">
      <xsl:choose>
        <xsl:when test="$preSlashPath">
          <xsl:call-template name="PathLink">
            <xsl:with-param name="path" select="$postSlashPath"/>
            <xsl:with-param name="parent" select="concat($parent,'/',$preSlashPath)"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="PathLink">
            <xsl:with-param name="path" select="$postSlashPath"/>
          </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>
</xsl:stylesheet>
