import sys, socket, types
import Modules, ServerConfig

from Ft.Xml.Xslt.StylesheetReader import DummyExpatParser, DomParser
from Ft.Xml import HAS_PYEXPAT
from Ft.Xml.Domlette import NonvalidatingReader


class ConfigParser:

    def __init__(self, verbose=0):
        # All servers support the core interface
        self._modules = []
        self._limitedNss = []
        self._nsChar = '^'
        self._verbose = verbose
        self._parser = None
        self._line = 0
        self._column = 0
        self.addModule(Modules.CoreModule)
        return

    def addModule(self, module):
        if not issubclass(module, Modules.Module):
            raise Exception('module is not of type ' + str(Modules.Module))
        added = module()
        self._modules.append(added)

        # Search for defined namespaces in commands
        for (namespace, name) in added.commands.keys():
            if namespace not in self._limitedNss:
                self._limitedNss.append(namespace)
        return

    def findHandler(self, name):
        # Modules added later have higher precedence
        for i in range(0, len(self._modules)+1):
            module = self._modules[-i]
            if module.handlers.has_key(name):
                return module.handlers[name]

        # Nothing found, signal such
        raise Exception("Invalid handler '%s', perhaps mis-spelled "
                        "or defined by a module not included in the "
                        "server configuration" % name)

    def findCommand(self, qname, nameparts):
        # Modules added later have higher precedence
        for i in range(0, len(self._modules)+1):
            module = self._modules[-i]
            if module.commands.has_key(nameparts):
                cmd = module.commands[nameparts]
                start = end = None
                if type(cmd) in [types.TupleType, types.ListType]:
                    start = getattr(module, cmd[0])
                    cmd = cmd[1]
                if cmd is not None:
                    end = getattr(module, cmd)
                return (start, end)

        # Nothing found, signal such
        raise Exception("Invalid command '%s', perhaps mis-spelled "
                        "or defined by a module not included in the "
                        "server configuration" % qname)

    def startNamespaceDecl(self, prefix, uri):
        # FIXME - While these are only for errors, we should keep
        #  them acurate
        self._currentNss[uri] = prefix
        self._reverseNss[prefix] = uri
        return

    def endNamespaceDecl(self, prefix):
	uri = self._reverseNss[prefix]
	if self._currentNss.has_key(uri):
	    #It might not be there if there are two prefixes with the name uri.  This seems to be only used for errors so we are OK
	    del self._currentNss[uri]
        del self._reverseNss[prefix]
        return

    def startElement(self, expanded, attrs):
        self._line = self._parser.ErrorLineNumber
        self._column = self._parser.ErrorColumnNumber
        name = expanded.split(self._nsChar)
        qname = name[-1]
        if len(name) > 2:
            namespace = self._nsChar.join(name[:-1])
            name = (namespace, name[-1])
            prefix = self._currentNss[namespace]
            if prefix:
                qname = prefix + ':' + qname
        elif len(name) == 1:
            name = (None, name)
        else:
            # This needs to be hashable, lists are not
            name = tuple(name)

        if name[0] in self._limitedNss:
            start, end = self.findCommand(qname, name)
            start and start(self, self.config, qname, attrs)
        else:
            end = None

        self._processing.append([(end, qname, name, attrs)])
        return

    def endElement(self, expanded):
        self._line = self._parser.ErrorLineNumber
        self._column = self._parser.ErrorColumnNumber
        parts = self._processing[-1]

        del self._processing[-1]

        command, qname, nameparts, attrs = parts[0]

        # Concatenate text chunks and remove leading & trailing whitespace
        data = ''.join(parts[1:]).strip()
        command and command(self, self.config, qname, data, attrs)
        return

    def characterData(self, data):
        self._line = self._parser.ErrorLineNumber
        self._column = self._parser.ErrorColumnNumber
        self._processing[-1].append(data)
        return

    def readConfig(self, path, source):
        self.config = ServerConfig.ServerConfig(path)
        self._processing = []
        self._currentNss = {}
        self._reverseNss = {}
        if HAS_PYEXPAT:
            from xml.parsers import expat
            self._parser = p = expat.ParserCreate(namespace_separator=self._nsChar)
            parserError = expat.ExpatError
            p.StartElementHandler = self.startElement
            p.EndElementHandler = self.endElement
            p.StartCdataSectionHandler = self.characterData
            p.CharacterDataHandler = self.characterData
            parseFunction = p.Parse
        else:
            doc = NonvalidatingReader.parseString(source, path)
            self._parser = p = DomParser(DummyExpatParser(self),nsSplit = self._nsChar)
            source = doc
            parserError = None
            parseFunction = p.parse
        try:
            parseFunction(source)
        except parserError, exc:
            # Convert to our exception
            raise Exception(str(exc))
        except Exception, exc:
            if self._verbose:
                print 'Original Traceback','-'*40
                import traceback
                traceback.print_exc()
                print '-'*40
            raise Exception('%s: line %s, column %s:\n%s' % (path,
                                                             str(self._line),
                                                             str(self._column),
                                                             str(exc)))
        return self.config
