########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/__init__.py,v 1.8 2004/10/07 08:30:00 mbrown Exp $
"""
Implementation of '4ss_manager' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command-line application allows a 4Suite repository \
administrator to perform management tasks on the repository as a \
whole, including setup, server control, backup, and other operations."""

from Ft.Lib.CommandLine import Options, CommandLineApp
from Ft.Server import FtServerBaseException

# command modules to register as subcommands
import Init
import Backup
#import Restore
import Recompile
import Start
import Stop
import Restart
#import Reload
import Status
import Log

g_commands = [
    # These commands deal directly with the data store
    Init,
    Backup,
    #Restore,
    Recompile,

    # These commands are for server control and info
    Start,
    Stop,
    Restart,
    #Reload,
    Status,
    Log,
    ]

# global options (inherited by all subcommands)
g_options = [
    Options.Option('u',
                   'username=USER',
                   'authenticate using the given user name'),
    Options.Option('p',
                   'password=PASSWORD',
                   'authenticate using the given password'),
    Options.Option('I',
                   'core-id=CORE',
                   'use a specific core in config file (default: Core)'),
    Options.Option('C',
                   'config-file=FILEPATH',
                   'use alternative repository configuration file'),
    ]


class ManagerCommandLineApp(CommandLineApp.CommandLineApp):

    def __init__(self):
        CommandLineApp.CommandLineApp.__init__(
            self,
            '4ss_manager',
            '4Suite repository management tools',
            __doc__,
            map(lambda x: x.Register(), g_commands),
            options=g_options,
            fileName=__file__,
            )

    def run(*args, **kwords):
        try:
            return CommandLineApp.CommandLineApp.run(*args, **kwords)
        except FtServerBaseException,e:
            print e
