########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/FtRpc/MessageSource.py,v 1.5 2004/01/26 07:40:19 jkloth Exp $
"""
Error codes and messages for the repository RPC server

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import TranslateMessage as _

class Error:
    INTERNAL_ERROR = 1
    TRANSACTION_IN_PROGRESS = 2
    TRANSACTION_NOT_IN_PROGRESS = 3

    NO_SERVER = 10
    SERVER_COMMS_ERROR = 11

    UNKNOWN_RESPONSE = 12
    UNKNOWN_COMMAND = 13

    SERVER_ERROR = 14
    FTSERVER_ERROR = 15

g_errorMessages = {
    Error.INTERNAL_ERROR: _('There is an internal bug in 4Suite Server. '
        'Please make a post to the 4Suite mailing list to report this error '
        'message to the developers. Include platform details and info about '
        'how to reproduce the error. Info about the mailing list is at '
        'http://lists.fourthought.com/mailman/listinfo/4suite. '
        'The error code to report is: %(message)s'),
    Error.TRANSACTION_IN_PROGRESS: _('Transaction already in progress'),
    Error.TRANSACTION_NOT_IN_PROGRESS: _('Transaction not in progress'),
    Error.NO_SERVER: _('No server was found at %(host)s:%(port)s'),
    Error.SERVER_COMMS_ERROR: _('Communication has terminated, or is '
                                'not using the correct protocol'),
    Error.UNKNOWN_RESPONSE: _("Unknown response code received: %(rspCode)s"),
    Error.UNKNOWN_COMMAND: _("Unknown command code received: %(cmdCode)s"),
    Error.SERVER_ERROR: _("The following error occurred on the server\n%(traceback)s"),
    Error.FTSERVER_ERROR: _("%(message)s"),

}

