########################################################################
#
# File Name:    Marshal.py
#
"""

WWW: http://4suite.org                  e-mail: support@4suite.org

Copyright 2001-2002 Fourthought, Inc., USA.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import socket, cPickle
from Ft.Server.FtRpc import FtServerFtRpcException, MessageSource, Error

__doc__ = """\
Code to marshal and unmarshal our little protocols messages.  A message
consists of:
  4 bytes for command/response code
  10 bytes for data length
  n bytes for data where n=length (cPickle)
"""

def Connect(userName, passwd, host, port):
    """Connect to an FtRpc Server """

    import Commands
    #Connect to the host on the specified port
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect((host, port))
    except socket.error:
        raise FtServerFtRpcException(Error.NO_SERVER,
                                     host=host,
                                     port=port)
 
    cmd = Commands.LoginCommand(userName, passwd)
    cmd.send(s)
    return s,'/'


def Marshal(cmd, data):
    """
    Turn a command and its data into a list of strings to be sent
    """
    cmdStr = "%04d" % cmd
    dataStr = cPickle.dumps(data,1)
    lenStr = "%010d" % len(dataStr)
    return cmdStr + lenStr + dataStr

# Use C-optomized sending loop if available (Python 2.1.2+)
import sys
_HAVE_SENDALL = sys.version >= '2.1.2'
del sys

def Send(s, cmd, data):
    """Send a command (or a response)"""
    if s is None:
	#Assume that the transaction has already ended
	raise FtServerFtRpcException(Error.TRANSACTION_NOT_IN_PROGRESS)

    cmdStr = Marshal(cmd, data)
    if _HAVE_SENDALL:
        s.sendall(cmdStr)
    else:
        # Send it in chunks
        #print "Sending: %r\n" % cmdStr
        length = len(cmdStr)
        offset = 0
	
        # Use buffer objects for improved performance
        while offset < length:
            bytes = s.send(buffer(cmdStr, offset))
            offset += bytes
    return


def Receive(s):
    """Read in a response (or a command)"""
    res = ""
    try:
        rspCode = s.recv(4)
        try:
            rspCode = int(rspCode)
        except ValueError:
            #Usually means the server bombed!!!
            raise FtServerFtRpcException(Error.SERVER_COMMS_ERROR)
            
        dataSize = int(s.recv(10))
        oSiz = dataSize
        while len(res) != oSiz:
            res = res + s.recv(dataSize)
            dataSize = oSiz - len(res)
        #print res,

        data = cPickle.loads(res)
        #print "-" * 40
        #print repr(data)
    except:
        #Leave the pass-through until we can properly propagate server-side exceptions...
        raise
        #Server bombed
        raise FtServerFtRpcException(Error.SERVER_COMMS_ERROR)

    return rspCode, data

