########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/__init__.py,v 1.12 2004/08/20 20:27:09 mbrown Exp $
"""
Implementation of '4ss' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command is a client that provides access to a \
4Suite repository and RDF model from the command line. \
The repository must exist and must be accessible via a 4Suite RPC \
server."""

from Ft.Lib.CommandLine import Options, CommandLineApp

# command modules to register as subcommands
import Add
import Agent
import Create
import Delete
import Export
import Fetch
import Install
import List
import Login
import Passwd
import Rdf
import Render
import Remove
import Set
import Update

g_commands = [Add,
              Agent,
              Create,
              Delete,
              Export,
              Fetch,
              Install,
              List,
              Login,
              Passwd,
              Rdf,
              Render,
              Remove,
              Set,
              Update,
              ]


# global options (inherited by all subcommands)
g_options = [Options.ExclusiveOptions([Options.Option('u',
                                                      'username=USER',
                                                      'connect using the given user name'),
                                       Options.Option('a',
                                                      'anonymous',
                                                      'connect as anonymous user'),
                                       ]),
             Options.Option(None,
                            'password=PASSWORD',
                            'connect using the given password'),
             Options.Option('p',
                            'port=PORT',
                            'the port to connect to'),
             Options.Option(None,
                            'host=HOST',
                            'the host to connect to'),
             ]


class GeneralCommandLineApp(CommandLineApp.CommandLineApp):

    def __init__(self):
        CommandLineApp.CommandLineApp.__init__(self,
                                               '4ss',
                                               'Command-line client for 4Suite repository access',
                                               __doc__,
                                               map(lambda x: x.Register(), g_commands),
                                               options = g_options,
                                               fileName = __file__,
                                               )

