from Ft import TranslateMessage as _
from Ft.Rdf import RdfException, ParseException
from Ft.Rdf.RdfsHandler import RdfsConstraintViolation

RDF_ERROR_MESSAGES = {
    RdfException.FEATURE_NOT_SUPPORTED: _('RDF 1.0 core feature not yet supported: %s'),
    RdfException.INVALID_FLAG: _('Invalid flag: "%s"'),
    RdfException.INVALID_CONTAINER_TYPE: _("Invalid Container Type: %s"),
    RdfException.INVALID_REGEX_STATEMENT: _("Invalid Regular Expression %s: %s"),
    RdfException.INVALID_ARGUMENT: _('Invalid argument: "%s"'),
    RdfException.ABOUT_EACH_OBJECT_NOT_CONTAINER: _("The object of a statement using aboutEach must be a container"),
    RdfException.MISSING_DRIVER: _('Missing driver'),
    #RdfException.: _(),
    }

PARSE_ERROR_MESSAGES = {
    #ParseException.: _(),
    ParseException.FEATURE_NOT_SUPPORTED: _('RDF 1.0 XML serialization feature not yet supported: %s'),
    ParseException.INVALID_PREDICATE: _('Invalid predicate in RDF base URI: %s'),
    ParseException.MULTIPLE_VALUE_OBJECTS: _('The value of property %s must be a single object or a string literal.'),
    ParseException.INVALID_CONTAINER_PROPERTY: _("Only member Attrs or members allowed on a container object"),
    ParseException.INVALID_CONTAINER_TYPE: _("Invalid container type: %s"),
    ParseException.NONEMPTY_PROPELT_WITH_PROPATTRS: _("%s, a non-empty property element must not have property attributes."),
    ParseException.NONEMPTY_PROPELT_WITH_RESATTR: _("%s, a non-empty property element must not have a resource attribute."),
    }

RDFS_ERROR_MESSAGES = {
    RdfsConstraintViolation.INVALID_DOMAIN_FOR_PROPERTY: _('"%s" is an invalid subject for "%s" according to domain constraints.'),
    RdfsConstraintViolation.INVALID_RANGE_FOR_PROPERTY: _('"%s" is an invalid object for "%s" according to range constraints.'),
    RdfsConstraintViolation.PROPERTY_HAS_MULTIPLE_RANGES: _('Property "%s" has multiple ranges.'),

    #RdfsException.: _(),
    }

