########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Lib/Set.py,v 1.5 2003/03/01 20:42:48 uogbuji Exp $
"""
Operations on sets

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

def Not(original, other):
    return [ i for i in original if i not in other ]


def Union(left, right):
    #Optimize by using the smaller list in comparison
    #But still try to minimize disruption of input ordering
    if len(left) < len(right):
        return [ i for i in left if i not in right ] + right
    else:
        return left + [ i for i in right if i not in left ]


def Intersection(left, right):
    if len(left) < len(right):
        loop = left
        compare = right
    else:
        loop = right
        compare = left
    return [ i for i in loop if i in compare ]


def Unique(left):
    return reduce(lambda rt, x: x in rt and rt or rt + [x], left, [])


