########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Lib/FtWarnings.py,v 1.6 2004/08/05 22:14:49 mbrown Exp $
"""
Warning functionality

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

import sys

from Ft.Lib import Wrap
from Ft.Lib.Terminfo import GetColumns

def _ftShowWarning(msg, category, filename, line, file=sys.stderr):
    """
    warnings.showwarning() replacement that word-wraps the message if
    file is a terminal, and doesn't add filename, line, stack info to
    RuntimeWarnings.
    """
    global RuntimeWarning
    if file.isatty():
        width = GetColumns(file)
        msg = Wrap(str(msg), width)
    if category in (RuntimeWarning,):
        file.write(msg + "\n")
        file.flush()
    else:
        msg = "\n" + msg
        global _origShowWarning
        _origShowWarning(msg, category, filename, line, file)

try:
    from warnings import *
    import warnings, exceptions
    RuntimeWarning = exceptions.RuntimeWarning
    DeprecationWarning = exceptions.DeprecationWarning
    warnings.showwarning = _ftShowWarning
except (ImportError,AttributeError):
    import sys
    filtered = 0
    def showwarning(msg,*args,**v_args):
        sys.stderr.write(msg + '\n')
        sys.stderr.flush()
    def warn(msg,*args,**v_args):
        if not filtered:
            showwarning(msg)
    def filterwarnings(st):
        global filtered
        if st == 'ignore':
            filtered = 1
        else:
            filtered = 0
    RuntimeWarning = None
    DeprecationWarning = None

_origShowWarning = showwarning
showwarning = _ftShowWarning
