"""Testbed for open/close PyTables files. This uses the HotShot profiler."""

import sys, os, getopt, pstats
import profile as prof
import time
import subprocess  # From Python 2.4 on
import tables

filename = None
niter = 1

def show_stats(explain, tref):
    "Show the used memory"
    # Build the command to obtain memory info (only for Linux 2.6.x)
    cmd = "cat /proc/%s/status" % os.getpid()
    sout = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE).stdout
    for line in sout:
        if line.startswith("VmSize:"):
            vmsize = int(line.split()[1])
        elif line.startswith("VmRSS:"):
            vmrss = int(line.split()[1])
        elif line.startswith("VmData:"):
            vmdata = int(line.split()[1])
        elif line.startswith("VmStk:"):
            vmstk = int(line.split()[1])
        elif line.startswith("VmExe:"):
            vmexe = int(line.split()[1])
        elif line.startswith("VmLib:"):
            vmlib = int(line.split()[1])
    sout.close()
    print "WallClock time:", time.time() - tref
    print "Memory usage: ******* %s *******" % explain
    print "VmSize: %7s kB\tVmRSS: %7s kB" % (vmsize, vmrss)
    print "VmData: %7s kB\tVmStk: %7s kB" % (vmdata, vmstk)
    print "VmExe:  %7s kB\tVmLib: %7s kB" % (vmexe, vmlib)

def check_open_close():
    #global filename, niter
    for i in range(niter):
        print "------------------ Opening #%s -------------------------" % i
        tref = time.time()
	fileh=tables.openFile(filename)
        #show_stats("Before closing file", tref)
	fileh.close()
        show_stats("After closing file", tref)

if __name__ == '__main__':

    usage = """usage: %s [-v] [-p] [-n niter] datafile
              -v verbose  (total dump of profiling)
	      -p do profiling
	      -n number of iterations for reading\n""" % sys.argv[0]

    try:
	opts, pargs = getopt.getopt(sys.argv[1:], 'vpn:')
    except:
	sys.stderr.write(usage)
	sys.exit(0)

    # if we pass too much parameters, abort
    if len(pargs) <> 1:
	sys.stderr.write(usage)
	sys.exit(0)

    # default options
    verbose = 0
    profile = 0

    # Get the options
    for option in opts:
	if option[0] == '-v':
	    verbose = 1
	elif option[0] == '-p':
	    profile = 1
	elif option[0] == '-n':
	    niter = int(option[1])

    filename = pargs[0]


    tref = time.time()
    if profile:
	prof.run('check_open_close()','open-close.prof')
	stats = pstats.Stats('open-close.prof')
	stats.strip_dirs()
	stats.sort_stats('time', 'calls')
	if verbose:
	    stats.print_stats()
	else:
	    stats.print_stats(20)
    else:
	check_open_close()

    print "------------------ End of run -------------------------"
    show_stats("Final statistics (after closing everything)", tref)

