/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointIteratorAbstract;

public abstract class PointIteratorFromStructureData
extends PointIteratorAbstract {
    private PointIteratorAbstract.Filter filter;
    private StructureDataIterator structIter;
    private PointFeature feature = null;
    private boolean finished = false;

    protected abstract PointFeature makeFeature(int var1, StructureData var2) throws IOException;

    public PointIteratorFromStructureData(StructureDataIterator structIter, PointIteratorAbstract.Filter filter) throws IOException {
        this.structIter = structIter;
        this.filter = filter;
    }

    public boolean hasNext() throws IOException {
        StructureData sdata;
        while ((sdata = this.nextStructureData()) != null) {
            this.feature = this.makeFeature(this.structIter.getCurrentRecno(), sdata);
            if (this.feature == null || this.feature.getLocation().isMissing() || this.filter != null && !this.filter.filter(this.feature)) continue;
            return true;
        }
        this.feature = null;
        this.finish();
        return false;
    }

    public PointFeature next() throws IOException {
        if (this.feature == null) {
            return null;
        }
        this.calcBounds(this.feature);
        return this.feature;
    }

    public void setBufferSize(int bytes) {
        this.structIter.setBufferSize(bytes);
    }

    public void finish() {
        if (this.finished) {
            return;
        }
        this.finishCalcBounds();
        this.finished = true;
    }

    private StructureData nextStructureData() throws IOException {
        return this.structIter.hasNext() ? this.structIter.next() : null;
    }
}

