#!/usr/local/bin/python -t
# $Id: help.py.in,v 1.3 2007/04/15 04:32:39 rockyb Exp $
"Unit test of getting help options "
import difflib, os, time, sys, unittest

top_builddir = "../"
if top_builddir[-1] != os.path.sep:
    top_builddir += os.path.sep
sys.path.insert(0, os.path.join(top_builddir, 'pydb'))
top_srcdir = ".."
if top_srcdir[-1] != os.path.sep:
    top_srcdir += os.path.sep
sys.path.insert(0, os.path.join(top_srcdir, 'pydb'))

builddir     = "."
if builddir[-1] != os.path.sep:
    builddir += os.path.sep

srcdir = "."
if srcdir[-1] != os.path.sep:
    srcdir += os.path.sep

pydir        = os.path.join(top_builddir, "pydb")
pydb_short   = "pydb.py"
pydb_path    = os.path.join(pydir, pydb_short)

def run_debugger(testname, pythonfile, pydb_opts='', args='', 
                 outfile=None, need_25=True):
    global srcdir, builddir, pydir

    if sys.version_info[0:2] == (2, 5) and need_25:
        rightfile   = os.path.join(srcdir, "%s-2.5.right" % testname)
    else:
        rightfile   = os.path.join(srcdir, "%s.right" % testname)

    outfile_opt = ''
    if outfile is None:
        outfile     = os.path.join(builddir, "%s.out" % testname)

    # print "builddir: %s, cmdfile: %s, outfile: %s, rightfile: %s" % \
    # (builddir, cmdfile, outfile, rightfile)

    if os.path.exists(outfile): os.unlink(outfile)

    os.environ['PYTHONPATH']=os.pathsep.join(sys.path)
    cmd = "%s %s %s %s >%s" % \
          (pydb_path, pydb_opts, pythonfile, args, outfile)
    
    os.system(cmd)
    fromfile  = rightfile
    fromdate  = time.ctime(os.stat(fromfile).st_mtime)
    fromlines = open(fromfile, 'U').readlines()[0:-2]
    tofile    = outfile
    todate    = time.ctime(os.stat(tofile).st_mtime)
    tolines   = open(tofile, 'U').readlines()[0:-2]
    # Curse you getopts! I'm so ashamed. 
    tolines[0] = fromlines[0].lower()  # Usage -> usage
    tolines[4] = fromlines[4].lower()  # Options -> options
    diff = list(difflib.unified_diff(fromlines, tolines, fromfile,
                                     tofile, fromdate, todate))
    if len(diff) == 0:
        os.unlink(outfile)
    for line in diff:
        print line,
    return len(diff) == 0
    
class PdbTests(unittest.TestCase):

    def test_help(self):
        """Test getting help: --help and -h options"""
        for trace_opt in ['--help', '-h']:
            result=run_debugger(testname='help',
                                pydb_opts='%s --help' % trace_opt,
                                pythonfile='', need_25 = False)
        self.assertEqual(True, result, 
                         "help listing output comparision" )
        

if __name__ == "__main__":
    unittest.main()
