#-*- coding: utf-8 -*-

licence={}
licence['en']="""
    pyacidobasic version %s:

    a program to simulate acido-basic equilibria
    
    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

licence['fr']=u"""
    pyacidobasic version %s:

    un programme pour simuler des équilibres acido-basiques
    
    Copyright (C) 2010 Georges Khaznadar <georgesk@ofset.org>
    
    Ce projet est un logiciel libre : vous pouvez le redistribuer, le modifier selon les terme de la GPL (GNU Public License) dans les termes de la Free Software Foundation concernant la version 3 ou plus de la dite licence.
    
    Ce programme est fait avec l'espoir qu'il sera utile mais SANS AUCUNE GARANTIE. Lisez la licence pour plus de détails.
    
    <http://www.gnu.org/licenses/>.
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.Qwt5 import QwtPlot, QwtPlotCurve, QwtPlotGrid, QwtLegend
from Ui_main import Ui_MainWindow
import reactifs, acidebase
import sys

class StartQT4(QMainWindow):
    def __init__(self, parent):
         ######QT
        QMainWindow.__init__(self)
        QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.maxBurette=20 # volume max versé de la burette
        self.configurePlot()
        reactifs.setupUi(self.ui,acidebase.listFromFile("acides-bases.txt"))
        self.ui_connections()

    def ui_connections(self):
        QObject.connect(self.ui.toolButtonBurette,SIGNAL("clicked()"), self.videBurette)
        QObject.connect(self.ui.toolButtonBecher,SIGNAL("clicked()"), self.videBecher)
        QObject.connect(self.ui.toolButtonPlusV,SIGNAL("clicked()"), self.plusV)
        QObject.connect(self.ui.toolButtonMoinsV,SIGNAL("clicked()"), self.moinsV)

    def configurePlot(self):
        self.ui.qwtPlotpH.setAxisScale(QwtPlot.yLeft,0,14)
        self.grid=QwtPlotGrid()
        p1=QPen(QColor(0,0,0,100)) # noir transparent 
        p1.setWidthF(2.5)
        p2=QPen(QColor(0,0,0,100)) # noir transparent 
        p1.setWidthF(0)
        self.grid.setMajPen(p1)
        self.grid.setMinPen(p2)
        self.grid.enableX(True)
        self.grid.enableY(True)
        self.grid.enableXMin(True)
        self.grid.enableYMin(True)
        self.grid.attach(self.ui.qwtPlotpH)
        self.replot()
        
    def replot(self):
        self.ui.qwtPlotpH.setAxisScale(QwtPlot.xBottom,0,self.maxBurette)
        self.ui.qwtPlotpH.setAxisTitle(QwtPlot.xBottom,"V (mL)")
        self.ui.qwtPlotpH.setAxisTitle(QwtPlot.yLeft,"pH")
        self.ui.qwtPlotpH.setTitle(u"Courbe du dosage")
        self.legend=QwtLegend()
        self.ui.qwtPlotpH.insertLegend(self.legend)
        self.ui.qwtPlotpH.replot()

    def videBurette(self):
        self.ui.listWidgetBurette.vide()
        try:
            self.courbe.detach()
        except:
            pass
        self.replot()

    def videBecher(self):
        self.ui.listWidgetBecher.vide()
        try:
            self.courbe.detach()
        except:
            pass
        self.replot()
       
    def plusV(self):
        self.maxBurette+=5
        self.replot()

    def moinsV(self):
        if self.maxBurette >= 10:
            self.maxBurette-=5
            self.replot()

    def simule(self):
        try:
            self.courbe.detach()
        except:
            pass
        self.courbe=QwtPlotCurve("pH")
        p1=QPen(QColor("red"))
        p1.setWidth(2)
        self.courbe.setPen(p1)
        vData=[]; pHData=[]
        for i in range (1401):
            pH=0.01*i # pH varie de 0 à 14
            try:
                v=-self.ui.listWidgetBecher.charge(pH)/self.ui.listWidgetBurette.charge(pH,1)
                if v>0:
                    vData.append(v); pHData.append(pH)
            except ZeroDivisionError:
                pass
        if len(self.ui.listWidgetBecher.contenu)>0 and len(self.ui.listWidgetBurette.contenu)>0:
            self.courbe.setData(vData, pHData)
            self.legend.insert(self.courbe, QLabel("pH"))
            self.courbe.attach(self.ui.qwtPlotpH)
        self.replot()

            

    def event(self, ev):
        if ev.type()==QEvent.User:
            self.simule()
            return True
        else:
            return QMainWindow.event(self,ev)

if __name__=='__main__':
    ###translation##
    locale = QLocale.system().name()
    #locale = QString("en_EN")
    
    qtTranslator = QTranslator()
    if qtTranslator.load("qt_" + locale):
        app.installTranslator(qtTranslator)
    appTranslator = QTranslator()
    #if appTranslator.load(pymecavideo_rep_langues+"/pymecavideo_" + locale):
    #    b = app.installTranslator(appTranslator)
        
    app = QApplication(sys.argv)
    
    w = StartQT4(None)
    w.show()
    sys.exit(app.exec_())
    
