/* PureAdmin
 * Copyright (C) 2003 Isak Savo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Preferences management - the GUI-part.
 *
 * Copyright (C) 2003 - Isak Savo
 */


#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "support.h"
#include "cfg.h"
#include "prefwin.h"
#include "helper.h"
#include "gui_helper.h"
#include "logfile.h"
#include "globals.h"
#include "dirbrowser.h"

void prefwin_menu_gid_changed (GtkOptionMenu *optionmenu, gpointer user_data);
void prefwin_menu_uid_changed (GtkOptionMenu *optionmenu, gpointer user_data);
void prefwin_rdo_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void prefwin_entry_changed (GtkEditable *editable, gpointer user_data);
void prefwin_btn_create_id (GtkButton *button, gpointer user_data);
void prefwin_btn_search_clicked (GtkButton *button, gpointer user_data);
void prefwin_chkbtn_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void prefwin_btn_browse_home_clicked (GtkButton *button, gpointer user_data);
GtkWidget *prefwin = NULL;

prefwin_widgets *prefwin_get_widgets (void)
{
   static prefwin_widgets *w = NULL;

   if (!prefwin)
     return NULL;
   
   if (!w)
   {
      w = (prefwin_widgets *) g_malloc0 (sizeof (prefwin_widgets));
      w->menu_uid = lookup_widget (prefwin, "opt_menu_uid");
      w->menu_gid = lookup_widget (prefwin, "opt_menu_gid");
      w->home = lookup_widget (prefwin, "entry_home");
      w->cmd_purepw = lookup_widget (prefwin, "entry_purepw_cmd");
      w->pwfile = lookup_widget (prefwin, "entry_passwd_file");
      w->pdbfile = lookup_widget (prefwin, "entry_pdb_file");
      w->btn_search = lookup_widget (prefwin, "btn_search_set_defaults");
      w->rdo_syslog = lookup_widget (prefwin, "rdo_syslog");
      w->rdo_custom = lookup_widget (prefwin, "rdo_custom");
      w->logfile = lookup_widget (prefwin, "entry_logfile");
      w->chk_resolve = lookup_widget (prefwin, "chk_resolve_hostnames");
      w->btn_home_browse = lookup_widget (prefwin, "btn_home_dir_browse");
   }
   return w;
}

void pref_init_prefwindow (GtkWidget *dlg)
{
   prefwin_widgets *w;
   GList *id;
   GtkWidget *menu;
   gint i;
   
   prefwin = dlg;
   w = prefwin_get_widgets ();
   
   if (!w)
   {
      g_error ("Preference window is not created!\n");
      return;
   }
   /* GID/UID Option menus */
   id = misc_get_user_ids ();
   menu = gui_create_menu_from_glist (id);
   gtk_option_menu_remove_menu (GTK_OPTION_MENU (w->menu_uid));
   gtk_option_menu_set_menu (GTK_OPTION_MENU (w->menu_uid), menu);
   g_object_set_data (G_OBJECT (w->menu_uid), "items", id);
   i = 0;
   while (id)
   {
      if (cfg.default_uid == atoi ((gchar *) id->data))
	break;
      i++;
      id = g_list_next (id);
   }
   gtk_option_menu_set_history (GTK_OPTION_MENU (w->menu_uid), i);

   id = misc_get_group_ids ();
   menu = gui_create_menu_from_glist (id);
   gtk_option_menu_remove_menu (GTK_OPTION_MENU (w->menu_gid));
   gtk_option_menu_set_menu (GTK_OPTION_MENU (w->menu_gid), menu);
   g_object_set_data (G_OBJECT (w->menu_gid), "items", id);
   i = 0;
   while (id)
   {
      if (cfg.default_gid == atoi ((gchar *) id->data))
	break;
      i++;
      id = g_list_next (id);
   }
   gtk_option_menu_set_history (GTK_OPTION_MENU (w->menu_gid), i);
   
   if (cfg.logmethod == LOG_SYSLOG)
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w->rdo_syslog), TRUE);
   else
     gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w->rdo_custom), TRUE);
   
   gtk_entry_set_text (GTK_ENTRY (w->home), cfg.default_home);
   gtk_entry_set_text (GTK_ENTRY (w->cmd_purepw), cfg.cmd_purepw);
   gtk_entry_set_text (GTK_ENTRY (w->pwfile), cfg.pwfile);
   gtk_entry_set_text (GTK_ENTRY (w->pdbfile), cfg.pdbfile);
   gtk_entry_set_text (GTK_ENTRY (w->logfile), cfg.logfile);
   gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w->chk_resolve), cfg.resolve_hostnames);
   /* Hookup signals for the widgets to allow 'instant-apply' */
   g_signal_connect ((gpointer) w->menu_uid, "changed",
                    G_CALLBACK (prefwin_menu_uid_changed),
                    NULL);
   g_signal_connect ((gpointer) w->menu_gid, "changed",
                    G_CALLBACK (prefwin_menu_gid_changed),
                    NULL);
   g_signal_connect ((gpointer) w->home, "changed",
                    G_CALLBACK (prefwin_entry_changed),
                    "home");
   g_signal_connect ((gpointer) w->cmd_purepw, "changed",
                    G_CALLBACK (prefwin_entry_changed),
		     "cmd_purepw");
   g_signal_connect ((gpointer) w->pwfile, "changed",
                    G_CALLBACK (prefwin_entry_changed),
		     "pwfile");
   g_signal_connect ((gpointer) w->pdbfile, "changed",
                    G_CALLBACK (prefwin_entry_changed),
                    "pdbfile");
   g_signal_connect ((gpointer) w->rdo_syslog, "toggled",
                    G_CALLBACK (prefwin_rdo_toggled),
                    GINT_TO_POINTER (LOG_SYSLOG));
   g_signal_connect ((gpointer) w->rdo_custom, "toggled",
                    G_CALLBACK (prefwin_rdo_toggled),
                    GINT_TO_POINTER (LOG_CUSTOM));
   g_signal_connect ((gpointer) w->logfile, "changed",
                    G_CALLBACK (prefwin_entry_changed),
                    "logfile");
   g_signal_connect ((gpointer) w->chk_resolve, "toggled",
                    G_CALLBACK (prefwin_chkbtn_toggled),
                    "resolve");
   
   /* Button Callbacks */
   g_signal_connect ((gpointer) w->btn_search, "clicked",
                    G_CALLBACK (prefwin_btn_search_clicked),
                    NULL);
   g_signal_connect ((gpointer) w->btn_home_browse, "clicked",
                    G_CALLBACK (prefwin_btn_browse_home_clicked),
                    NULL);

}

void prefwin_menu_gid_changed (GtkOptionMenu *optionmenu, gpointer user_data)
{
   GList *id;
   gint node_no;
   
   id = (GList *) g_object_get_data (G_OBJECT (optionmenu), "items");
   node_no = gtk_option_menu_get_history (optionmenu);
   id = g_list_nth (id, node_no);
   if (!id)
     g_print ("Gid change: Wrong history: %d\n", node_no);
}

void prefwin_menu_uid_changed (GtkOptionMenu *optionmenu, gpointer user_data)
{
   GList *id;
   gint node_no;
   
   id = (GList *) g_object_get_data (G_OBJECT (optionmenu), "items");
   node_no = gtk_option_menu_get_history (optionmenu);
   id = g_list_nth (id, node_no);
   if (!id)
     g_print ("Uid change: Wrong history: %d\n", node_no);
}

void prefwin_rdo_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
   GtkWidget *entry;
   
   if (!gtk_toggle_button_get_active (togglebutton))
     return;
   entry = lookup_widget (prefwin, "entry_logfile");
   
   cfg.logmethod = GPOINTER_TO_INT (user_data);
   switch (GPOINTER_TO_INT (user_data))
   {
      case LOG_SYSLOG: /* Syslog selected */
	gtk_entry_set_text (GTK_ENTRY (entry), "/var/log/messages");
	break;
      case LOG_CUSTOM: /* Custom selected */
	gtk_entry_set_text (GTK_ENTRY (entry), "/var/log/pureftpd.log");
	break;
   }
}

void prefwin_chkbtn_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
   gchar *arg = (gchar *) user_data;

   if (strncmp (arg, "resolve", 7) == 0)
     cfg.resolve_hostnames = gtk_toggle_button_get_active (togglebutton);
}

void prefwin_entry_changed (GtkEditable *editable, gpointer user_data)
{
   gchar *tmp;
   gchar *ename;
   ename = (gchar *) user_data;
   tmp = gtk_editable_get_chars (GTK_EDITABLE (editable), 0, -1);
   
/*    g_print ("Entry [%s] changed into: %s\n", ename, tmp); */
   if (strncmp (ename, "home", 4) == 0)
   {
      g_free (cfg.default_home);
      cfg.default_home = tmp;
   }
   else if (strncmp (ename, "cmd_purepw", 10) == 0)
   {
      g_free (cfg.cmd_purepw);
      cfg.cmd_purepw = tmp;
   }
   else if (strncmp (ename, "pwfile", 6) == 0)
   {
      g_free (cfg.pwfile);
      cfg.pwfile = tmp;
   } 
   else if (strncmp (ename, "pdbfile", 6) == 0)
   {
      g_free (cfg.pdbfile);
      cfg.pdbfile = tmp;
   }
   else if (strncmp (ename, "logfile", 10) == 0)
   {
      if (*tmp == '/' && g_file_test (tmp, G_FILE_TEST_IS_REGULAR))
      {
	 /* FIXME: Should we present some logic here to determine if it really is a log-file? */
	 close_logfile ();
	 g_free (cfg.logfile);
	 cfg.logfile = tmp;
	 init_logfile ();
      }
      else
	g_free (tmp);
   }
   else
     g_free (tmp);
}

void prefwin_btn_search_clicked (GtkButton *button, gpointer user_data)
{
   prefwin_widgets *w;

   w = prefwin_get_widgets ();
   
   gtk_entry_set_text (GTK_ENTRY (w->cmd_purepw), srv_vars.cmd_pure_pw);
   gtk_entry_set_text (GTK_ENTRY (w->pwfile), srv_vars.fl_pwfile);
   gtk_entry_set_text (GTK_ENTRY (w->pdbfile), srv_vars.fl_pdbfile);
}

void prefwin_btn_browse_home_clicked (GtkButton *button, gpointer user_data)
{
   prefwin_widgets *w;
   GtkWidget *dbr;
   gchar *dir;
   gint response;
   
   w = prefwin_get_widgets ();
   dbr = dirbrowser_new (_("Select Default Home Directory"));
   if (g_file_test (cfg.default_home, G_FILE_TEST_IS_DIR))
     dirbrowser_set_directory (DIRBROWSER (dbr), cfg.default_home);

   response = gtk_dialog_run (GTK_DIALOG (dbr));
   if (response == GTK_RESPONSE_OK)
   {
      dir = dirbrowser_get_directory (DIRBROWSER (dbr));
      gtk_entry_set_text (GTK_ENTRY (w->home), dir);
      g_free (dir);
   }
   gtk_widget_destroy (dbr);
}
