/* $Cambridge: hermes/src/prayer/shared/user_agent.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Preferences and overrides involving interaction with the user agent */

struct user_agent {
    struct pool *pool;          /* Allocation pool */
    char *agent;                /* "User-Agent:" string from browser */
    BOOL manual;                /* Manual intervention by user */
    BOOL use_override;          /* Override defaults */
    BOOL use_debug;             /* Enable debug */
    BOOL use_telemetry;         /* Enable telemetry */
    BOOL use_telemetry_all;     /* Enable full telemetry */
    BOOL use_telemetry_frontend;        /* Enable telemetry:frontend servers */

    BOOL use_icons;             /* Enable icons */
    BOOL use_cookie;            /* Enable HTTP Cookie */
    BOOL use_substitution;      /* Enable Page substitution */
    BOOL use_direct;            /* Enable direct connection mode */
    BOOL use_persist;           /* Enable persistent HTTP connections */
    BOOL use_http_1_1;          /* Enable HTTP/1.1 */
    BOOL use_pipelining;        /* Enable HTTP/1.1 Pipelining */
    BOOL use_short;             /* Enable short URLS */
    BOOL use_gzip;              /* Enable gzip or x-gzip encoding */
};


struct user_agent *user_agent_create(struct pool *pool);
void user_agent_free(struct user_agent *user_agent);

struct user_agent *user_agent_clone(struct pool *pool,
                                    struct user_agent *src);

void user_agent_copy(struct user_agent *dest, struct user_agent *src);

void user_agent_generate_form(struct buffer *b, struct user_agent *ua);

void user_agent_process_form(struct user_agent *ua, struct assoc *h);

BOOL
user_agent_process_argv(struct user_agent *ua, char *string,
                        struct pool *p);

char *user_agent_options(struct user_agent *ua);

void user_agent_parse(struct user_agent *ua, char *string);

void user_agent_setup_browser(struct user_agent *user_agent,
                              char *browser);
