/*
 *
 *
 *                           Policy Daemon
 *
 *  policy daemon is used in conjuction with postfix to combat spam.
 *
 *  Copyright (C) 2004 Cami Sardinha (cami@mweb.co.za)
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the  GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  This program  is  distributed  in the hope that  it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *
 */

/* INCLUDES */
#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <netinet/in.h>
#include <sys/signal.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <syslog.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <stdio.h>
#include <mysql.h>
#include <ctype.h>
#include <setjmp.h>

/* CONFIGS */
#define PROJECT		"policyd"
#define VERSION		"v1.55"

/* Miscellaneous constants */
#define LISTENQ         1023    /* 2nd argument to listen() */
#define MAXLINE         1023    /* max text line length */
#define BUFFSIZE        8191    /* buffer size for reads and writes */
#define MAXFDS		1023	/* max file descriptors   */
#define BUFSIZE         4095 

#define POSTFIX_X_HEADER	"action=prepend X-Greylist: Passed"
#define POSTFIX_GOOD    	"action=dunno\n\n"
#define POSTFIX_GREYLIST	"action=defer_if_permit Policy Rejection:"
#define POSTFIX_BAD_SIZE	"action=reject Policy Rejection:"
#define POSTFIX_QUOTA_EXCEEDED	"action=reject Policy Rejection:"
#define POSTFIX_SPAMTRAP      	"action=reject Policy Rejection:"
#define POSTFIX_BLACKLIST_PERM	"action=reject Policy Rejection:"
#define POSTFIX_BLACKLIST_TEMP 	"action=defer_if_permit Policy Rejection:"


/* MySQL VARIABLES */
char *MYSQLHOST;
char *MYSQLUSER;
char *MYSQLPASS;
char *MYSQLDBASE;
 int MYSQLPORT;

 
/* GLOBAL OPTARGS */
 char *configpath;
 int DEBUG;
 int DAEMON;
 int FAILSAFE;
 int TRIPLET_TIME;
 int TRIPLET_AUTH_TIMEOUT;
 int TRIPLET_UNAUTH_TIMEOUT;
 int OPTINOUT;
 int OPTINOUTALL;
 int TRAINING_MODE;
 int AUTO_WHITE_LISTING;
 int AUTO_WHITELIST_NUMBER;
 int AUTO_BLACKLIST_NUMBER;
 int AUTO_WHITELIST_EXPIRE;
 int AUTO_BLACKLIST_EXPIRE;
 int AUTO_WHITELIST_NETBLOCK;
 int SPAMTRAP_AUTO_EXPIRE;
 int WHITELISTING;
 int WHITELISTNULL;
 int BLACKLIST_TEMP_REJECT;
 int BLACKLISTING;
 int BLACKLIST_TIMEOUT;
 int BLACKLIST_NETBLOCK;
 int BLACKLIST_HELO;
 int BLACKLIST_HELO_AUTO_EXPIRE;
 int AUTO_BLACK_LISTING;
 int GREYLISTING;
 int SPAMTRAPPING;
 int GREYLIST_X_HEADER;
 int BINDPORT;
 int SENDERTHROTTLE;
 int SENDER_THROTTLE_SASL;
 int SENDER_THROTTLE_HOST;
 int SENDERMSGLIMIT;
 int SENDERTIMELIMIT;
 int SENDERQUOTALIMIT;
 int SENDERMSGSIZE;
 int SYSLOG_FACILITY;
 int DATABASE_KEEPALIVE;
 int count;
 uid_t UID;
 gid_t GID;
 char *BINDHOST;
 char *CHROOT;
 char *PIDFILE;
 char *postfix_greylist;
 char *postfix_bad_size;
 char *postfix_spamtrap;
 char *postfix_blacklist;
 char *postfix_quota_exceeded;

 
/* GLOBAL VARIABLES/ARRAYS */
 MYSQL * volatile mysql;
unsigned long int rcpt_count;		/* total mails processed */
unsigned long int mysql_count;		/* total mysql queries   */
unsigned long int mysql_failure_count;	/* total mysql queries   */
         long int last_mail_time;	/* seconds since epoch   */
         long int last_mysql_failure;	/* seconds since epoch   */
       sigjmp_buf sjmp;

  int msock;                     	/* master server socket  */
  int ssock;                     	/* slave server socket   */
  int       mysql_array[MAXFDS][10];
  int    mysql_optarray[MAXFDS][1];
  char  mysqlchar_array[MAXFDS][10][64];
  char       host_array[MAXFDS][10][64];
  char     policy_array[MAXFDS][10][64];
  char    triplet_array[MAXFDS][10][64];
  char mysqlquery_array[MAXFDS][512];
  char  xgreylist_array[MAXFDS][128];
  char    extract_array[MAXFDS][64];
  char extract_ip_array[MAXFDS][64];
  char      return_code[MAXFDS][64];
  unsigned int i[MAXFDS];
  int x[MAXFDS], y[MAXFDS];
  struct timeval timevalue;     /* gettimeofday() */
  int timenow;
  FILE *fd_config, *pidfile;
  int  action_array[MAXFDS];
  char confbuf[256];
  char buf[MAXFDS][MAXLINE];


/*  PROTOTYPES */

  // sockets
  int w_select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout);
  int w_socket(int family, int type, int protocol);
  int w_accept(int fd, struct sockaddr *sa, socklen_t *salenptr);
  int w_write(int fd, void *ptr, int nbytes);
  int socktimeout(int fd, int sec);
  int daemonize(int nochdir, int noclose);
const char *w_inet_ntop(int family, const void *addrptr, char *strptr, size_t len);
  pid_t w_fork(void);
 ssize_t w_read(int volatile fd, void *ptr, size_t nbytes);
 ssize_t f_write(int volatile fd, const void *vptr, size_t n);
 void w_close(int fd);
 void w_bind(int fd, const struct sockaddr *sa, socklen_t salen);
 void w_listen(int fd, int backlog);
 void sigalrm_handler (void);

  // functions
  int chk_pol(int fd);
  int bindsock(int port, int qlen);
  int greylist_check(int fd);
  int spamtrap_check(int fd);
  int throttle_check(int fd);
  int module_info_check(int fd);
  int blacklist_helo_check(int fd);
  int gettime(void);
  int db_failure(int fd, char *module);
  int whitelist_check(int fd);
  int policy_reply(int fd, int code);
  int blacklist_check(int fd);
  int whitelist_check(int fd);
  int extract_seconds(char *token);
  int parse_syslog_priority (char *str);
  int database_probe(int fd);
 void drop_privs(void);
 void read_conf(int prog);
 void logmessage(const char *fmt, ...);
 void usage(char *usag);
 void clear_var(int fd);
 void parse_buf(int fd, char *buf);
 void fold();
 void extract(int fd, char *token, int startlen);
 void extract_ip(int fd, char *token);
 void syslog_token_set (char *token, int *value);
 char *strip_space (char *str);
  
 
  // mysql
 int db_doquery(int volatile fd);
 int db_optquery(int volatile fd);
 int db_charquery(int volatile fd);
 int db_deletequery(int volatile fd);
 int w_mysql_query(int volatile fd, const char *function);
MYSQL *db_connect(const char *dbname);



/* EOF */
